/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.SendAutomationSignalRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link SendAutomationSignalRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class SendAutomationSignalRequestModelMarshaller {
    private static final MarshallingInfo<String> AUTOMATIONEXECUTIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutomationExecutionId").isBinary(false).build();

    private static final MarshallingInfo<String> SIGNALTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SignalType").isBinary(false).build();

    private static final MarshallingInfo<Map> PAYLOAD_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Payload").isBinary(false).build();

    private static final SendAutomationSignalRequestModelMarshaller INSTANCE = new SendAutomationSignalRequestModelMarshaller();

    private SendAutomationSignalRequestModelMarshaller() {
    }

    public static SendAutomationSignalRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(SendAutomationSignalRequest sendAutomationSignalRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(sendAutomationSignalRequest, "sendAutomationSignalRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(sendAutomationSignalRequest.automationExecutionId(), AUTOMATIONEXECUTIONID_BINDING);
            protocolMarshaller.marshall(sendAutomationSignalRequest.signalTypeAsString(), SIGNALTYPE_BINDING);
            protocolMarshaller.marshall(sendAutomationSignalRequest.payload(), PAYLOAD_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
