/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncItem;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ResourceDataSyncItem} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ResourceDataSyncItemMarshaller {
    private static final MarshallingInfo<String> SYNCNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SyncName").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> S3DESTINATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Destination")
            .isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTSYNCTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastSyncTime").isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTSUCCESSFULSYNCTIME_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("LastSuccessfulSyncTime").isBinary(false).build();

    private static final MarshallingInfo<String> LASTSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastStatus").isBinary(false).build();

    private static final MarshallingInfo<Instant> SYNCCREATEDTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SyncCreatedTime").isBinary(false).build();

    private static final ResourceDataSyncItemMarshaller INSTANCE = new ResourceDataSyncItemMarshaller();

    private ResourceDataSyncItemMarshaller() {
    }

    public static ResourceDataSyncItemMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ResourceDataSyncItem resourceDataSyncItem, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(resourceDataSyncItem, "resourceDataSyncItem");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(resourceDataSyncItem.syncName(), SYNCNAME_BINDING);
            protocolMarshaller.marshall(resourceDataSyncItem.s3Destination(), S3DESTINATION_BINDING);
            protocolMarshaller.marshall(resourceDataSyncItem.lastSyncTime(), LASTSYNCTIME_BINDING);
            protocolMarshaller.marshall(resourceDataSyncItem.lastSuccessfulSyncTime(), LASTSUCCESSFULSYNCTIME_BINDING);
            protocolMarshaller.marshall(resourceDataSyncItem.lastStatusAsString(), LASTSTATUS_BINDING);
            protocolMarshaller.marshall(resourceDataSyncItem.syncCreatedTime(), SYNCCREATEDTIME_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
