/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.AssociationVersionInfo;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link AssociationVersionInfo} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class AssociationVersionInfoMarshaller {
    private static final MarshallingInfo<String> ASSOCIATIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssociationId").isBinary(false).build();

    private static final MarshallingInfo<String> ASSOCIATIONVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssociationVersion").isBinary(false).build();

    private static final MarshallingInfo<Instant> CREATEDDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedDate").isBinary(false).build();

    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();

    private static final MarshallingInfo<String> DOCUMENTVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentVersion").isBinary(false).build();

    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").isBinary(false).build();

    private static final MarshallingInfo<List> TARGETS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Targets").isBinary(false).build();

    private static final MarshallingInfo<String> SCHEDULEEXPRESSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScheduleExpression").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> OUTPUTLOCATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("OutputLocation").isBinary(false).build();

    private static final MarshallingInfo<String> ASSOCIATIONNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssociationName").isBinary(false).build();

    private static final AssociationVersionInfoMarshaller INSTANCE = new AssociationVersionInfoMarshaller();

    private AssociationVersionInfoMarshaller() {
    }

    public static AssociationVersionInfoMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(AssociationVersionInfo associationVersionInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(associationVersionInfo, "associationVersionInfo");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(associationVersionInfo.associationId(), ASSOCIATIONID_BINDING);
            protocolMarshaller.marshall(associationVersionInfo.associationVersion(), ASSOCIATIONVERSION_BINDING);
            protocolMarshaller.marshall(associationVersionInfo.createdDate(), CREATEDDATE_BINDING);
            protocolMarshaller.marshall(associationVersionInfo.name(), NAME_BINDING);
            protocolMarshaller.marshall(associationVersionInfo.documentVersion(), DOCUMENTVERSION_BINDING);
            protocolMarshaller.marshall(associationVersionInfo.parameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall(associationVersionInfo.targets(), TARGETS_BINDING);
            protocolMarshaller.marshall(associationVersionInfo.scheduleExpression(), SCHEDULEEXPRESSION_BINDING);
            protocolMarshaller.marshall(associationVersionInfo.outputLocation(), OUTPUTLOCATION_BINDING);
            protocolMarshaller.marshall(associationVersionInfo.associationName(), ASSOCIATIONNAME_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
