/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class SendCommandRequest extends SSMRequest implements ToCopyableBuilder<SendCommandRequest.Builder, SendCommandRequest> {
    private final List<String> instanceIds;

    private final List<Target> targets;

    private final String documentName;

    private final String documentHash;

    private final String documentHashType;

    private final Integer timeoutSeconds;

    private final String comment;

    private final Map<String, List<String>> parameters;

    private final String outputS3Region;

    private final String outputS3BucketName;

    private final String outputS3KeyPrefix;

    private final String maxConcurrency;

    private final String maxErrors;

    private final String serviceRoleArn;

    private final NotificationConfig notificationConfig;

    private SendCommandRequest(BuilderImpl builder) {
        super(builder);
        this.instanceIds = builder.instanceIds;
        this.targets = builder.targets;
        this.documentName = builder.documentName;
        this.documentHash = builder.documentHash;
        this.documentHashType = builder.documentHashType;
        this.timeoutSeconds = builder.timeoutSeconds;
        this.comment = builder.comment;
        this.parameters = builder.parameters;
        this.outputS3Region = builder.outputS3Region;
        this.outputS3BucketName = builder.outputS3BucketName;
        this.outputS3KeyPrefix = builder.outputS3KeyPrefix;
        this.maxConcurrency = builder.maxConcurrency;
        this.maxErrors = builder.maxErrors;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.notificationConfig = builder.notificationConfig;
    }

    /**
     * <p>
     * The instance IDs where the command should execute. You can specify a maximum of 50 IDs. If you prefer not to list
     * individual instance IDs, you can instead send commands to a fleet of instances using the Targets parameter, which
     * accepts EC2 tags. For more information about how to use Targets, see <a
     * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Sending Commands
     * to a Fleet</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The instance IDs where the command should execute. You can specify a maximum of 50 IDs. If you prefer not
     *         to list individual instance IDs, you can instead send commands to a fleet of instances using the Targets
     *         parameter, which accepts EC2 tags. For more information about how to use Targets, see <a
     *         href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Sending
     *         Commands to a Fleet</a>.
     */
    public List<String> instanceIds() {
        return instanceIds;
    }

    /**
     * <p>
     * (Optional) An array of search criteria that targets instances using a Key,Value combination that you specify.
     * Targets is required if you don't provide one or more instance IDs in the call. For more information about how to
     * use Targets, see <a
     * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Sending Commands
     * to a Fleet</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return (Optional) An array of search criteria that targets instances using a Key,Value combination that you
     *         specify. Targets is required if you don't provide one or more instance IDs in the call. For more
     *         information about how to use Targets, see <a
     *         href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Sending
     *         Commands to a Fleet</a>.
     */
    public List<Target> targets() {
        return targets;
    }

    /**
     * <p>
     * Required. The name of the Systems Manager document to execute. This can be a public document or a custom
     * document.
     * </p>
     * 
     * @return Required. The name of the Systems Manager document to execute. This can be a public document or a custom
     *         document.
     */
    public String documentName() {
        return documentName;
    }

    /**
     * <p>
     * The Sha256 or Sha1 hash created by the system when the document was created.
     * </p>
     * <note>
     * <p>
     * Sha1 hashes have been deprecated.
     * </p>
     * </note>
     * 
     * @return The Sha256 or Sha1 hash created by the system when the document was created. </p> <note>
     *         <p>
     *         Sha1 hashes have been deprecated.
     *         </p>
     */
    public String documentHash() {
        return documentHash;
    }

    /**
     * <p>
     * Sha256 or Sha1.
     * </p>
     * <note>
     * <p>
     * Sha1 hashes have been deprecated.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #documentHashType}
     * will return {@link DocumentHashType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #documentHashTypeAsString}.
     * </p>
     * 
     * @return Sha256 or Sha1.</p> <note>
     *         <p>
     *         Sha1 hashes have been deprecated.
     *         </p>
     * @see DocumentHashType
     */
    public DocumentHashType documentHashType() {
        return DocumentHashType.fromValue(documentHashType);
    }

    /**
     * <p>
     * Sha256 or Sha1.
     * </p>
     * <note>
     * <p>
     * Sha1 hashes have been deprecated.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #documentHashType}
     * will return {@link DocumentHashType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #documentHashTypeAsString}.
     * </p>
     * 
     * @return Sha256 or Sha1.</p> <note>
     *         <p>
     *         Sha1 hashes have been deprecated.
     *         </p>
     * @see DocumentHashType
     */
    public String documentHashTypeAsString() {
        return documentHashType;
    }

    /**
     * <p>
     * If this time is reached and the command has not already started executing, it will not execute.
     * </p>
     * 
     * @return If this time is reached and the command has not already started executing, it will not execute.
     */
    public Integer timeoutSeconds() {
        return timeoutSeconds;
    }

    /**
     * <p>
     * User-specified information about the command, such as a brief description of what the command should do.
     * </p>
     * 
     * @return User-specified information about the command, such as a brief description of what the command should do.
     */
    public String comment() {
        return comment;
    }

    /**
     * <p>
     * The required and optional parameters specified in the document being executed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The required and optional parameters specified in the document being executed.
     */
    public Map<String, List<String>> parameters() {
        return parameters;
    }

    /**
     * <p>
     * (Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager
     * automatically determines the Amazon S3 bucket region.
     * </p>
     * 
     * @return (Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager
     *         automatically determines the Amazon S3 bucket region.
     */
    public String outputS3Region() {
        return outputS3Region;
    }

    /**
     * <p>
     * The name of the S3 bucket where command execution responses should be stored.
     * </p>
     * 
     * @return The name of the S3 bucket where command execution responses should be stored.
     */
    public String outputS3BucketName() {
        return outputS3BucketName;
    }

    /**
     * <p>
     * The directory structure within the S3 bucket where the responses should be stored.
     * </p>
     * 
     * @return The directory structure within the S3 bucket where the responses should be stored.
     */
    public String outputS3KeyPrefix() {
        return outputS3KeyPrefix;
    }

    /**
     * <p>
     * (Optional) The maximum number of instances that are allowed to execute the command at the same time. You can
     * specify a number such as 10 or a percentage such as 10%. The default value is 50. For more information about how
     * to use MaxConcurrency, see <a
     * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-velocity.html">Using Concurrency
     * Controls</a>.
     * </p>
     * 
     * @return (Optional) The maximum number of instances that are allowed to execute the command at the same time. You
     *         can specify a number such as 10 or a percentage such as 10%. The default value is 50. For more
     *         information about how to use MaxConcurrency, see <a
     *         href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-velocity.html">Using
     *         Concurrency Controls</a>.
     */
    public String maxConcurrency() {
        return maxConcurrency;
    }

    /**
     * <p>
     * The maximum number of errors allowed without the command failing. When the command fails one more time beyond the
     * value of MaxErrors, the systems stops sending the command to additional targets. You can specify a number like 10
     * or a percentage like 10%. The default value is 50. For more information about how to use MaxErrors, see <a
     * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-maxerrors.html">Using Error
     * Controls</a>.
     * </p>
     * 
     * @return The maximum number of errors allowed without the command failing. When the command fails one more time
     *         beyond the value of MaxErrors, the systems stops sending the command to additional targets. You can
     *         specify a number like 10 or a percentage like 10%. The default value is 50. For more information about
     *         how to use MaxErrors, see <a
     *         href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-maxerrors.html">Using
     *         Error Controls</a>.
     */
    public String maxErrors() {
        return maxErrors;
    }

    /**
     * <p>
     * The IAM role that Systems Manager uses to send notifications.
     * </p>
     * 
     * @return The IAM role that Systems Manager uses to send notifications.
     */
    public String serviceRoleArn() {
        return serviceRoleArn;
    }

    /**
     * <p>
     * Configurations for sending notifications.
     * </p>
     * 
     * @return Configurations for sending notifications.
     */
    public NotificationConfig notificationConfig() {
        return notificationConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceIds());
        hashCode = 31 * hashCode + Objects.hashCode(targets());
        hashCode = 31 * hashCode + Objects.hashCode(documentName());
        hashCode = 31 * hashCode + Objects.hashCode(documentHash());
        hashCode = 31 * hashCode + Objects.hashCode(documentHashTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(outputS3Region());
        hashCode = 31 * hashCode + Objects.hashCode(outputS3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(outputS3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(maxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(notificationConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendCommandRequest)) {
            return false;
        }
        SendCommandRequest other = (SendCommandRequest) obj;
        return Objects.equals(instanceIds(), other.instanceIds()) && Objects.equals(targets(), other.targets())
                && Objects.equals(documentName(), other.documentName()) && Objects.equals(documentHash(), other.documentHash())
                && Objects.equals(documentHashTypeAsString(), other.documentHashTypeAsString())
                && Objects.equals(timeoutSeconds(), other.timeoutSeconds()) && Objects.equals(comment(), other.comment())
                && Objects.equals(parameters(), other.parameters()) && Objects.equals(outputS3Region(), other.outputS3Region())
                && Objects.equals(outputS3BucketName(), other.outputS3BucketName())
                && Objects.equals(outputS3KeyPrefix(), other.outputS3KeyPrefix())
                && Objects.equals(maxConcurrency(), other.maxConcurrency()) && Objects.equals(maxErrors(), other.maxErrors())
                && Objects.equals(serviceRoleArn(), other.serviceRoleArn())
                && Objects.equals(notificationConfig(), other.notificationConfig());
    }

    @Override
    public String toString() {
        return ToString.builder("SendCommandRequest").add("InstanceIds", instanceIds()).add("Targets", targets())
                .add("DocumentName", documentName()).add("DocumentHash", documentHash())
                .add("DocumentHashType", documentHashTypeAsString()).add("TimeoutSeconds", timeoutSeconds())
                .add("Comment", comment()).add("Parameters", parameters()).add("OutputS3Region", outputS3Region())
                .add("OutputS3BucketName", outputS3BucketName()).add("OutputS3KeyPrefix", outputS3KeyPrefix())
                .add("MaxConcurrency", maxConcurrency()).add("MaxErrors", maxErrors()).add("ServiceRoleArn", serviceRoleArn())
                .add("NotificationConfig", notificationConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceIds":
            return Optional.of(clazz.cast(instanceIds()));
        case "Targets":
            return Optional.of(clazz.cast(targets()));
        case "DocumentName":
            return Optional.of(clazz.cast(documentName()));
        case "DocumentHash":
            return Optional.of(clazz.cast(documentHash()));
        case "DocumentHashType":
            return Optional.of(clazz.cast(documentHashTypeAsString()));
        case "TimeoutSeconds":
            return Optional.of(clazz.cast(timeoutSeconds()));
        case "Comment":
            return Optional.of(clazz.cast(comment()));
        case "Parameters":
            return Optional.of(clazz.cast(parameters()));
        case "OutputS3Region":
            return Optional.of(clazz.cast(outputS3Region()));
        case "OutputS3BucketName":
            return Optional.of(clazz.cast(outputS3BucketName()));
        case "OutputS3KeyPrefix":
            return Optional.of(clazz.cast(outputS3KeyPrefix()));
        case "MaxConcurrency":
            return Optional.of(clazz.cast(maxConcurrency()));
        case "MaxErrors":
            return Optional.of(clazz.cast(maxErrors()));
        case "ServiceRoleArn":
            return Optional.of(clazz.cast(serviceRoleArn()));
        case "NotificationConfig":
            return Optional.of(clazz.cast(notificationConfig()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMRequest.Builder, CopyableBuilder<Builder, SendCommandRequest> {
        /**
         * <p>
         * The instance IDs where the command should execute. You can specify a maximum of 50 IDs. If you prefer not to
         * list individual instance IDs, you can instead send commands to a fleet of instances using the Targets
         * parameter, which accepts EC2 tags. For more information about how to use Targets, see <a
         * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Sending
         * Commands to a Fleet</a>.
         * </p>
         * 
         * @param instanceIds
         *        The instance IDs where the command should execute. You can specify a maximum of 50 IDs. If you prefer
         *        not to list individual instance IDs, you can instead send commands to a fleet of instances using the
         *        Targets parameter, which accepts EC2 tags. For more information about how to use Targets, see <a
         *        href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Sending
         *        Commands to a Fleet</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(Collection<String> instanceIds);

        /**
         * <p>
         * The instance IDs where the command should execute. You can specify a maximum of 50 IDs. If you prefer not to
         * list individual instance IDs, you can instead send commands to a fleet of instances using the Targets
         * parameter, which accepts EC2 tags. For more information about how to use Targets, see <a
         * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Sending
         * Commands to a Fleet</a>.
         * </p>
         * 
         * @param instanceIds
         *        The instance IDs where the command should execute. You can specify a maximum of 50 IDs. If you prefer
         *        not to list individual instance IDs, you can instead send commands to a fleet of instances using the
         *        Targets parameter, which accepts EC2 tags. For more information about how to use Targets, see <a
         *        href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Sending
         *        Commands to a Fleet</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(String... instanceIds);

        /**
         * <p>
         * (Optional) An array of search criteria that targets instances using a Key,Value combination that you specify.
         * Targets is required if you don't provide one or more instance IDs in the call. For more information about how
         * to use Targets, see <a
         * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Sending
         * Commands to a Fleet</a>.
         * </p>
         * 
         * @param targets
         *        (Optional) An array of search criteria that targets instances using a Key,Value combination that you
         *        specify. Targets is required if you don't provide one or more instance IDs in the call. For more
         *        information about how to use Targets, see <a
         *        href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Sending
         *        Commands to a Fleet</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<Target> targets);

        /**
         * <p>
         * (Optional) An array of search criteria that targets instances using a Key,Value combination that you specify.
         * Targets is required if you don't provide one or more instance IDs in the call. For more information about how
         * to use Targets, see <a
         * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Sending
         * Commands to a Fleet</a>.
         * </p>
         * 
         * @param targets
         *        (Optional) An array of search criteria that targets instances using a Key,Value combination that you
         *        specify. Targets is required if you don't provide one or more instance IDs in the call. For more
         *        information about how to use Targets, see <a
         *        href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Sending
         *        Commands to a Fleet</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Target... targets);

        /**
         * <p>
         * (Optional) An array of search criteria that targets instances using a Key,Value combination that you specify.
         * Targets is required if you don't provide one or more instance IDs in the call. For more information about how
         * to use Targets, see <a
         * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Sending
         * Commands to a Fleet</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Target>.Builder} avoiding the need to
         * create one manually via {@link List<Target>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Target>.Builder#build()} is called immediately and its
         * result is passed to {@link #targets(List<Target>)}.
         * 
         * @param targets
         *        a consumer that will call methods on {@link List<Target>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targets(List<Target>)
         */
        Builder targets(Consumer<Target.Builder>... targets);

        /**
         * <p>
         * Required. The name of the Systems Manager document to execute. This can be a public document or a custom
         * document.
         * </p>
         * 
         * @param documentName
         *        Required. The name of the Systems Manager document to execute. This can be a public document or a
         *        custom document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentName(String documentName);

        /**
         * <p>
         * The Sha256 or Sha1 hash created by the system when the document was created.
         * </p>
         * <note>
         * <p>
         * Sha1 hashes have been deprecated.
         * </p>
         * </note>
         * 
         * @param documentHash
         *        The Sha256 or Sha1 hash created by the system when the document was created. </p> <note>
         *        <p>
         *        Sha1 hashes have been deprecated.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentHash(String documentHash);

        /**
         * <p>
         * Sha256 or Sha1.
         * </p>
         * <note>
         * <p>
         * Sha1 hashes have been deprecated.
         * </p>
         * </note>
         * 
         * @param documentHashType
         *        Sha256 or Sha1.</p> <note>
         *        <p>
         *        Sha1 hashes have been deprecated.
         *        </p>
         * @see DocumentHashType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentHashType
         */
        Builder documentHashType(String documentHashType);

        /**
         * <p>
         * Sha256 or Sha1.
         * </p>
         * <note>
         * <p>
         * Sha1 hashes have been deprecated.
         * </p>
         * </note>
         * 
         * @param documentHashType
         *        Sha256 or Sha1.</p> <note>
         *        <p>
         *        Sha1 hashes have been deprecated.
         *        </p>
         * @see DocumentHashType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentHashType
         */
        Builder documentHashType(DocumentHashType documentHashType);

        /**
         * <p>
         * If this time is reached and the command has not already started executing, it will not execute.
         * </p>
         * 
         * @param timeoutSeconds
         *        If this time is reached and the command has not already started executing, it will not execute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutSeconds(Integer timeoutSeconds);

        /**
         * <p>
         * User-specified information about the command, such as a brief description of what the command should do.
         * </p>
         * 
         * @param comment
         *        User-specified information about the command, such as a brief description of what the command should
         *        do.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * The required and optional parameters specified in the document being executed.
         * </p>
         * 
         * @param parameters
         *        The required and optional parameters specified in the document being executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, ? extends Collection<String>> parameters);

        /**
         * <p>
         * (Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager
         * automatically determines the Amazon S3 bucket region.
         * </p>
         * 
         * @param outputS3Region
         *        (Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager
         *        automatically determines the Amazon S3 bucket region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3Region(String outputS3Region);

        /**
         * <p>
         * The name of the S3 bucket where command execution responses should be stored.
         * </p>
         * 
         * @param outputS3BucketName
         *        The name of the S3 bucket where command execution responses should be stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3BucketName(String outputS3BucketName);

        /**
         * <p>
         * The directory structure within the S3 bucket where the responses should be stored.
         * </p>
         * 
         * @param outputS3KeyPrefix
         *        The directory structure within the S3 bucket where the responses should be stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3KeyPrefix(String outputS3KeyPrefix);

        /**
         * <p>
         * (Optional) The maximum number of instances that are allowed to execute the command at the same time. You can
         * specify a number such as 10 or a percentage such as 10%. The default value is 50. For more information about
         * how to use MaxConcurrency, see <a
         * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-velocity.html">Using
         * Concurrency Controls</a>.
         * </p>
         * 
         * @param maxConcurrency
         *        (Optional) The maximum number of instances that are allowed to execute the command at the same time.
         *        You can specify a number such as 10 or a percentage such as 10%. The default value is 50. For more
         *        information about how to use MaxConcurrency, see <a
         *        href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-velocity.html">Using
         *        Concurrency Controls</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrency(String maxConcurrency);

        /**
         * <p>
         * The maximum number of errors allowed without the command failing. When the command fails one more time beyond
         * the value of MaxErrors, the systems stops sending the command to additional targets. You can specify a number
         * like 10 or a percentage like 10%. The default value is 50. For more information about how to use MaxErrors,
         * see <a href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-maxerrors.html">Using
         * Error Controls</a>.
         * </p>
         * 
         * @param maxErrors
         *        The maximum number of errors allowed without the command failing. When the command fails one more time
         *        beyond the value of MaxErrors, the systems stops sending the command to additional targets. You can
         *        specify a number like 10 or a percentage like 10%. The default value is 50. For more information about
         *        how to use MaxErrors, see <a
         *        href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-maxerrors.html">Using
         *        Error Controls</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxErrors(String maxErrors);

        /**
         * <p>
         * The IAM role that Systems Manager uses to send notifications.
         * </p>
         * 
         * @param serviceRoleArn
         *        The IAM role that Systems Manager uses to send notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRoleArn(String serviceRoleArn);

        /**
         * <p>
         * Configurations for sending notifications.
         * </p>
         * 
         * @param notificationConfig
         *        Configurations for sending notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationConfig(NotificationConfig notificationConfig);

        /**
         * <p>
         * Configurations for sending notifications.
         * </p>
         * This is a convenience that creates an instance of the {@link NotificationConfig.Builder} avoiding the need to
         * create one manually via {@link NotificationConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link NotificationConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #notificationConfig(NotificationConfig)}.
         * 
         * @param notificationConfig
         *        a consumer that will call methods on {@link NotificationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationConfig(NotificationConfig)
         */
        default Builder notificationConfig(Consumer<NotificationConfig.Builder> notificationConfig) {
            return notificationConfig(NotificationConfig.builder().apply(notificationConfig).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SSMRequest.BuilderImpl implements Builder {
        private List<String> instanceIds;

        private List<Target> targets;

        private String documentName;

        private String documentHash;

        private String documentHashType;

        private Integer timeoutSeconds;

        private String comment;

        private Map<String, List<String>> parameters;

        private String outputS3Region;

        private String outputS3BucketName;

        private String outputS3KeyPrefix;

        private String maxConcurrency;

        private String maxErrors;

        private String serviceRoleArn;

        private NotificationConfig notificationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(SendCommandRequest model) {
            super(model);
            instanceIds(model.instanceIds);
            targets(model.targets);
            documentName(model.documentName);
            documentHash(model.documentHash);
            documentHashType(model.documentHashType);
            timeoutSeconds(model.timeoutSeconds);
            comment(model.comment);
            parameters(model.parameters);
            outputS3Region(model.outputS3Region);
            outputS3BucketName(model.outputS3BucketName);
            outputS3KeyPrefix(model.outputS3KeyPrefix);
            maxConcurrency(model.maxConcurrency);
            maxErrors(model.maxErrors);
            serviceRoleArn(model.serviceRoleArn);
            notificationConfig(model.notificationConfig);
        }

        public final Collection<String> getInstanceIds() {
            return instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdListCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String... instanceIds) {
            instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdListCopier.copy(instanceIds);
        }

        public final Collection<Target.Builder> getTargets() {
            return targets != null ? targets.stream().map(Target::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder>... targets) {
            targets(Stream.of(targets).map(c -> Target.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        public final String getDocumentName() {
            return documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        public final String getDocumentHash() {
            return documentHash;
        }

        @Override
        public final Builder documentHash(String documentHash) {
            this.documentHash = documentHash;
            return this;
        }

        public final void setDocumentHash(String documentHash) {
            this.documentHash = documentHash;
        }

        public final String getDocumentHashType() {
            return documentHashType;
        }

        @Override
        public final Builder documentHashType(String documentHashType) {
            this.documentHashType = documentHashType;
            return this;
        }

        @Override
        public final Builder documentHashType(DocumentHashType documentHashType) {
            this.documentHashType(documentHashType.toString());
            return this;
        }

        public final void setDocumentHashType(String documentHashType) {
            this.documentHashType = documentHashType;
        }

        public final Integer getTimeoutSeconds() {
            return timeoutSeconds;
        }

        @Override
        public final Builder timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public final void setTimeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
        }

        public final String getOutputS3Region() {
            return outputS3Region;
        }

        @Override
        public final Builder outputS3Region(String outputS3Region) {
            this.outputS3Region = outputS3Region;
            return this;
        }

        public final void setOutputS3Region(String outputS3Region) {
            this.outputS3Region = outputS3Region;
        }

        public final String getOutputS3BucketName() {
            return outputS3BucketName;
        }

        @Override
        public final Builder outputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
            return this;
        }

        public final void setOutputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
        }

        public final String getOutputS3KeyPrefix() {
            return outputS3KeyPrefix;
        }

        @Override
        public final Builder outputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
            return this;
        }

        public final void setOutputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
        }

        public final String getMaxConcurrency() {
            return maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        public final String getMaxErrors() {
            return maxErrors;
        }

        @Override
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        public final String getServiceRoleArn() {
            return serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final NotificationConfig.Builder getNotificationConfig() {
            return notificationConfig != null ? notificationConfig.toBuilder() : null;
        }

        @Override
        public final Builder notificationConfig(NotificationConfig notificationConfig) {
            this.notificationConfig = notificationConfig;
            return this;
        }

        public final void setNotificationConfig(NotificationConfig.BuilderImpl notificationConfig) {
            this.notificationConfig = notificationConfig != null ? notificationConfig.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SendCommandRequest build() {
            return new SendCommandRequest(this);
        }
    }
}
