/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.ParameterStringFilterMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * One or more filters. Use a filter to return a more specific list of results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ParameterStringFilter implements StructuredPojo,
        ToCopyableBuilder<ParameterStringFilter.Builder, ParameterStringFilter> {
    private final String key;

    private final String option;

    private final List<String> values;

    private ParameterStringFilter(BuilderImpl builder) {
        this.key = builder.key;
        this.option = builder.option;
        this.values = builder.values;
    }

    /**
     * <p>
     * The name of the filter.
     * </p>
     * 
     * @return The name of the filter.
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * Valid options are Equals and BeginsWith. For Path filter, valid options are Recursive and OneLevel.
     * </p>
     * 
     * @return Valid options are Equals and BeginsWith. For Path filter, valid options are Recursive and OneLevel.
     */
    public String option() {
        return option;
    }

    /**
     * <p>
     * The value you want to search for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value you want to search for.
     */
    public List<String> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(option());
        hashCode = 31 * hashCode + Objects.hashCode(values());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterStringFilter)) {
            return false;
        }
        ParameterStringFilter other = (ParameterStringFilter) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(option(), other.option())
                && Objects.equals(values(), other.values());
    }

    @Override
    public String toString() {
        return ToString.builder("ParameterStringFilter").add("Key", key()).add("Option", option()).add("Values", values())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.of(clazz.cast(key()));
        case "Option":
            return Optional.of(clazz.cast(option()));
        case "Values":
            return Optional.of(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ParameterStringFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ParameterStringFilter> {
        /**
         * <p>
         * The name of the filter.
         * </p>
         * 
         * @param key
         *        The name of the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * Valid options are Equals and BeginsWith. For Path filter, valid options are Recursive and OneLevel.
         * </p>
         * 
         * @param option
         *        Valid options are Equals and BeginsWith. For Path filter, valid options are Recursive and OneLevel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder option(String option);

        /**
         * <p>
         * The value you want to search for.
         * </p>
         * 
         * @param values
         *        The value you want to search for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * The value you want to search for.
         * </p>
         * 
         * @param values
         *        The value you want to search for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String option;

        private List<String> values;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterStringFilter model) {
            key(model.key);
            option(model.option);
            values(model.values);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getOption() {
            return option;
        }

        @Override
        public final Builder option(String option) {
            this.option = option;
            return this;
        }

        public final void setOption(String option) {
            this.option = option;
        }

        public final Collection<String> getValues() {
            return values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ParameterStringFilterValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = ParameterStringFilterValueListCopier.copy(values);
        }

        @Override
        public ParameterStringFilter build() {
            return new ParameterStringFilter(this);
        }
    }
}
