/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.NonCompliantSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of resources that are not compliant. The summary is organized according to resource type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class NonCompliantSummary implements StructuredPojo, ToCopyableBuilder<NonCompliantSummary.Builder, NonCompliantSummary> {
    private final Integer nonCompliantCount;

    private final SeveritySummary severitySummary;

    private NonCompliantSummary(BuilderImpl builder) {
        this.nonCompliantCount = builder.nonCompliantCount;
        this.severitySummary = builder.severitySummary;
    }

    /**
     * <p>
     * The total number of compliance items that are not compliant.
     * </p>
     * 
     * @return The total number of compliance items that are not compliant.
     */
    public Integer nonCompliantCount() {
        return nonCompliantCount;
    }

    /**
     * <p>
     * A summary of the non-compliance severity by compliance type
     * </p>
     * 
     * @return A summary of the non-compliance severity by compliance type
     */
    public SeveritySummary severitySummary() {
        return severitySummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nonCompliantCount());
        hashCode = 31 * hashCode + Objects.hashCode(severitySummary());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NonCompliantSummary)) {
            return false;
        }
        NonCompliantSummary other = (NonCompliantSummary) obj;
        return Objects.equals(nonCompliantCount(), other.nonCompliantCount())
                && Objects.equals(severitySummary(), other.severitySummary());
    }

    @Override
    public String toString() {
        return ToString.builder("NonCompliantSummary").add("NonCompliantCount", nonCompliantCount())
                .add("SeveritySummary", severitySummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NonCompliantCount":
            return Optional.of(clazz.cast(nonCompliantCount()));
        case "SeveritySummary":
            return Optional.of(clazz.cast(severitySummary()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NonCompliantSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, NonCompliantSummary> {
        /**
         * <p>
         * The total number of compliance items that are not compliant.
         * </p>
         * 
         * @param nonCompliantCount
         *        The total number of compliance items that are not compliant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonCompliantCount(Integer nonCompliantCount);

        /**
         * <p>
         * A summary of the non-compliance severity by compliance type
         * </p>
         * 
         * @param severitySummary
         *        A summary of the non-compliance severity by compliance type
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severitySummary(SeveritySummary severitySummary);

        /**
         * <p>
         * A summary of the non-compliance severity by compliance type
         * </p>
         * This is a convenience that creates an instance of the {@link SeveritySummary.Builder} avoiding the need to
         * create one manually via {@link SeveritySummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link SeveritySummary.Builder#build()} is called immediately and its
         * result is passed to {@link #severitySummary(SeveritySummary)}.
         * 
         * @param severitySummary
         *        a consumer that will call methods on {@link SeveritySummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #severitySummary(SeveritySummary)
         */
        default Builder severitySummary(Consumer<SeveritySummary.Builder> severitySummary) {
            return severitySummary(SeveritySummary.builder().apply(severitySummary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer nonCompliantCount;

        private SeveritySummary severitySummary;

        private BuilderImpl() {
        }

        private BuilderImpl(NonCompliantSummary model) {
            nonCompliantCount(model.nonCompliantCount);
            severitySummary(model.severitySummary);
        }

        public final Integer getNonCompliantCount() {
            return nonCompliantCount;
        }

        @Override
        public final Builder nonCompliantCount(Integer nonCompliantCount) {
            this.nonCompliantCount = nonCompliantCount;
            return this;
        }

        public final void setNonCompliantCount(Integer nonCompliantCount) {
            this.nonCompliantCount = nonCompliantCount;
        }

        public final SeveritySummary.Builder getSeveritySummary() {
            return severitySummary != null ? severitySummary.toBuilder() : null;
        }

        @Override
        public final Builder severitySummary(SeveritySummary severitySummary) {
            this.severitySummary = severitySummary;
            return this;
        }

        public final void setSeveritySummary(SeveritySummary.BuilderImpl severitySummary) {
            this.severitySummary = severitySummary != null ? severitySummary.build() : null;
        }

        @Override
        public NonCompliantSummary build() {
            return new NonCompliantSummary(this);
        }
    }
}
