/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * One or more content items is not valid.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InvalidItemContentException extends SSMException implements
        ToCopyableBuilder<InvalidItemContentException.Builder, InvalidItemContentException> {
    private final String typeName;

    private InvalidItemContentException(BuilderImpl builder) {
        super(builder.message);
        this.typeName = builder.typeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the TypeName property for this object.
     * 
     * @return The value of the TypeName property for this object.
     */
    public String typeName() {
        return typeName;
    }

    public interface Builder extends CopyableBuilder<Builder, InvalidItemContentException> {
        /**
         * Sets the value of the TypeName property for this object.
         *
         * @param typeName
         *        The new value for the TypeName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String typeName;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidItemContentException model) {
            typeName(model.typeName);
            this.message = model.getMessage();
        }

        public final String getTypeName() {
            return typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        @JsonProperty("TypeName")
        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public String getMessage() {
            return message;
        }

        public String message() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public InvalidItemContentException build() {
            return new InvalidItemContentException(this);
        }
    }
}
