/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetDeployablePatchSnapshotForInstanceResponse extends SSMResponse implements
        ToCopyableBuilder<GetDeployablePatchSnapshotForInstanceResponse.Builder, GetDeployablePatchSnapshotForInstanceResponse> {
    private final String instanceId;

    private final String snapshotId;

    private final String snapshotDownloadUrl;

    private final String product;

    private GetDeployablePatchSnapshotForInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.snapshotId = builder.snapshotId;
        this.snapshotDownloadUrl = builder.snapshotDownloadUrl;
        this.product = builder.product;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The user-defined snapshot ID.
     * </p>
     * 
     * @return The user-defined snapshot ID.
     */
    public String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * A pre-signed Amazon S3 URL that can be used to download the patch snapshot.
     * </p>
     * 
     * @return A pre-signed Amazon S3 URL that can be used to download the patch snapshot.
     */
    public String snapshotDownloadUrl() {
        return snapshotDownloadUrl;
    }

    /**
     * <p>
     * Returns the specific operating system (for example Windows Server 2012 or Amazon Linux 2015.09) on the instance
     * for the specified patch snapshot.
     * </p>
     * 
     * @return Returns the specific operating system (for example Windows Server 2012 or Amazon Linux 2015.09) on the
     *         instance for the specified patch snapshot.
     */
    public String product() {
        return product;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotDownloadUrl());
        hashCode = 31 * hashCode + Objects.hashCode(product());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeployablePatchSnapshotForInstanceResponse)) {
            return false;
        }
        GetDeployablePatchSnapshotForInstanceResponse other = (GetDeployablePatchSnapshotForInstanceResponse) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(snapshotId(), other.snapshotId())
                && Objects.equals(snapshotDownloadUrl(), other.snapshotDownloadUrl())
                && Objects.equals(product(), other.product());
    }

    @Override
    public String toString() {
        return ToString.builder("GetDeployablePatchSnapshotForInstanceResponse").add("InstanceId", instanceId())
                .add("SnapshotId", snapshotId()).add("SnapshotDownloadUrl", snapshotDownloadUrl()).add("Product", product())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "SnapshotId":
            return Optional.of(clazz.cast(snapshotId()));
        case "SnapshotDownloadUrl":
            return Optional.of(clazz.cast(snapshotDownloadUrl()));
        case "Product":
            return Optional.of(clazz.cast(product()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMResponse.Builder, CopyableBuilder<Builder, GetDeployablePatchSnapshotForInstanceResponse> {
        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The user-defined snapshot ID.
         * </p>
         * 
         * @param snapshotId
         *        The user-defined snapshot ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * A pre-signed Amazon S3 URL that can be used to download the patch snapshot.
         * </p>
         * 
         * @param snapshotDownloadUrl
         *        A pre-signed Amazon S3 URL that can be used to download the patch snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotDownloadUrl(String snapshotDownloadUrl);

        /**
         * <p>
         * Returns the specific operating system (for example Windows Server 2012 or Amazon Linux 2015.09) on the
         * instance for the specified patch snapshot.
         * </p>
         * 
         * @param product
         *        Returns the specific operating system (for example Windows Server 2012 or Amazon Linux 2015.09) on the
         *        instance for the specified patch snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder product(String product);
    }

    static final class BuilderImpl extends SSMResponse.BuilderImpl implements Builder {
        private String instanceId;

        private String snapshotId;

        private String snapshotDownloadUrl;

        private String product;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeployablePatchSnapshotForInstanceResponse model) {
            super(model);
            instanceId(model.instanceId);
            snapshotId(model.snapshotId);
            snapshotDownloadUrl(model.snapshotDownloadUrl);
            product(model.product);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final String getSnapshotDownloadUrl() {
            return snapshotDownloadUrl;
        }

        @Override
        public final Builder snapshotDownloadUrl(String snapshotDownloadUrl) {
            this.snapshotDownloadUrl = snapshotDownloadUrl;
            return this;
        }

        public final void setSnapshotDownloadUrl(String snapshotDownloadUrl) {
            this.snapshotDownloadUrl = snapshotDownloadUrl;
        }

        public final String getProduct() {
            return product;
        }

        @Override
        public final Builder product(String product) {
            this.product = product;
            return this;
        }

        public final void setProduct(String product) {
            this.product = product;
        }

        @Override
        public GetDeployablePatchSnapshotForInstanceResponse build() {
            return new GetDeployablePatchSnapshotForInstanceResponse(this);
        }
    }
}
