/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeParametersRequest extends SSMRequest implements
        ToCopyableBuilder<DescribeParametersRequest.Builder, DescribeParametersRequest> {
    private final List<ParametersFilter> filters;

    private final List<ParameterStringFilter> parameterFilters;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeParametersRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.parameterFilters = builder.parameterFilters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * One or more filters. Use a filter to return a more specific list of results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters. Use a filter to return a more specific list of results.
     */
    public List<ParametersFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * Filters to limit the request results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Filters to limit the request results.
     */
    public List<ParameterStringFilter> parameterFilters() {
        return parameterFilters;
    }

    /**
     * <p>
     * The maximum number of items to return for this call. The call also returns a token that you can specify in a
     * subsequent call to get the next set of results.
     * </p>
     * 
     * @return The maximum number of items to return for this call. The call also returns a token that you can specify
     *         in a subsequent call to get the next set of results.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(parameterFilters());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeParametersRequest)) {
            return false;
        }
        DescribeParametersRequest other = (DescribeParametersRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(parameterFilters(), other.parameterFilters())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeParametersRequest").add("Filters", filters())
                .add("ParameterFilters", parameterFilters()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "ParameterFilters":
            return Optional.of(clazz.cast(parameterFilters()));
        case "MaxResults":
            return Optional.of(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMRequest.Builder, CopyableBuilder<Builder, DescribeParametersRequest> {
        /**
         * <p>
         * One or more filters. Use a filter to return a more specific list of results.
         * </p>
         * 
         * @param filters
         *        One or more filters. Use a filter to return a more specific list of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<ParametersFilter> filters);

        /**
         * <p>
         * One or more filters. Use a filter to return a more specific list of results.
         * </p>
         * 
         * @param filters
         *        One or more filters. Use a filter to return a more specific list of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ParametersFilter... filters);

        /**
         * <p>
         * One or more filters. Use a filter to return a more specific list of results.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ParametersFilter>.Builder} avoiding the
         * need to create one manually via {@link List<ParametersFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ParametersFilter>.Builder#build()} is called immediately and
         * its result is passed to {@link #filters(List<ParametersFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<ParametersFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<ParametersFilter>)
         */
        Builder filters(Consumer<ParametersFilter.Builder>... filters);

        /**
         * <p>
         * Filters to limit the request results.
         * </p>
         * 
         * @param parameterFilters
         *        Filters to limit the request results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterFilters(Collection<ParameterStringFilter> parameterFilters);

        /**
         * <p>
         * Filters to limit the request results.
         * </p>
         * 
         * @param parameterFilters
         *        Filters to limit the request results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterFilters(ParameterStringFilter... parameterFilters);

        /**
         * <p>
         * Filters to limit the request results.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ParameterStringFilter>.Builder} avoiding
         * the need to create one manually via {@link List<ParameterStringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ParameterStringFilter>.Builder#build()} is called
         * immediately and its result is passed to {@link #parameterFilters(List<ParameterStringFilter>)}.
         * 
         * @param parameterFilters
         *        a consumer that will call methods on {@link List<ParameterStringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameterFilters(List<ParameterStringFilter>)
         */
        Builder parameterFilters(Consumer<ParameterStringFilter.Builder>... parameterFilters);

        /**
         * <p>
         * The maximum number of items to return for this call. The call also returns a token that you can specify in a
         * subsequent call to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this call. The call also returns a token that you can
         *        specify in a subsequent call to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SSMRequest.BuilderImpl implements Builder {
        private List<ParametersFilter> filters;

        private List<ParameterStringFilter> parameterFilters;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeParametersRequest model) {
            super(model);
            filters(model.filters);
            parameterFilters(model.parameterFilters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<ParametersFilter.Builder> getFilters() {
            return filters != null ? filters.stream().map(ParametersFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<ParametersFilter> filters) {
            this.filters = ParametersFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ParametersFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<ParametersFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> ParametersFilter.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<ParametersFilter.BuilderImpl> filters) {
            this.filters = ParametersFilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<ParameterStringFilter.Builder> getParameterFilters() {
            return parameterFilters != null ? parameterFilters.stream().map(ParameterStringFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameterFilters(Collection<ParameterStringFilter> parameterFilters) {
            this.parameterFilters = ParameterStringFilterListCopier.copy(parameterFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterFilters(ParameterStringFilter... parameterFilters) {
            parameterFilters(Arrays.asList(parameterFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterFilters(Consumer<ParameterStringFilter.Builder>... parameterFilters) {
            parameterFilters(Stream.of(parameterFilters).map(c -> ParameterStringFilter.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setParameterFilters(Collection<ParameterStringFilter.BuilderImpl> parameterFilters) {
            this.parameterFilters = ParameterStringFilterListCopier.copyFromBuilder(parameterFilters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeParametersRequest build() {
            return new DescribeParametersRequest(this);
        }
    }
}
