/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeMaintenanceWindowTargetsResponse extends SSMResponse implements
        ToCopyableBuilder<DescribeMaintenanceWindowTargetsResponse.Builder, DescribeMaintenanceWindowTargetsResponse> {
    private final List<MaintenanceWindowTarget> targets;

    private final String nextToken;

    private DescribeMaintenanceWindowTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.targets = builder.targets;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the targets in the Maintenance Window.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the targets in the Maintenance Window.
     */
    public List<MaintenanceWindowTarget> targets() {
        return targets;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targets());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowTargetsResponse)) {
            return false;
        }
        DescribeMaintenanceWindowTargetsResponse other = (DescribeMaintenanceWindowTargetsResponse) obj;
        return Objects.equals(targets(), other.targets()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeMaintenanceWindowTargetsResponse").add("Targets", targets())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Targets":
            return Optional.of(clazz.cast(targets()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMResponse.Builder, CopyableBuilder<Builder, DescribeMaintenanceWindowTargetsResponse> {
        /**
         * <p>
         * Information about the targets in the Maintenance Window.
         * </p>
         * 
         * @param targets
         *        Information about the targets in the Maintenance Window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<MaintenanceWindowTarget> targets);

        /**
         * <p>
         * Information about the targets in the Maintenance Window.
         * </p>
         * 
         * @param targets
         *        Information about the targets in the Maintenance Window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(MaintenanceWindowTarget... targets);

        /**
         * <p>
         * Information about the targets in the Maintenance Window.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MaintenanceWindowTarget>.Builder} avoiding
         * the need to create one manually via {@link List<MaintenanceWindowTarget>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MaintenanceWindowTarget>.Builder#build()} is called
         * immediately and its result is passed to {@link #targets(List<MaintenanceWindowTarget>)}.
         * 
         * @param targets
         *        a consumer that will call methods on {@link List<MaintenanceWindowTarget>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targets(List<MaintenanceWindowTarget>)
         */
        Builder targets(Consumer<MaintenanceWindowTarget.Builder>... targets);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SSMResponse.BuilderImpl implements Builder {
        private List<MaintenanceWindowTarget> targets;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowTargetsResponse model) {
            super(model);
            targets(model.targets);
            nextToken(model.nextToken);
        }

        public final Collection<MaintenanceWindowTarget.Builder> getTargets() {
            return targets != null ? targets.stream().map(MaintenanceWindowTarget::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<MaintenanceWindowTarget> targets) {
            this.targets = MaintenanceWindowTargetListCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(MaintenanceWindowTarget... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<MaintenanceWindowTarget.Builder>... targets) {
            targets(Stream.of(targets).map(c -> MaintenanceWindowTarget.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargets(Collection<MaintenanceWindowTarget.BuilderImpl> targets) {
            this.targets = MaintenanceWindowTargetListCopier.copyFromBuilder(targets);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeMaintenanceWindowTargetsResponse build() {
            return new DescribeMaintenanceWindowTargetsResponse(this);
        }
    }
}
