/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeInstancePatchesResponse extends SSMResponse implements
        ToCopyableBuilder<DescribeInstancePatchesResponse.Builder, DescribeInstancePatchesResponse> {
    private final List<PatchComplianceData> patches;

    private final String nextToken;

    private DescribeInstancePatchesResponse(BuilderImpl builder) {
        super(builder);
        this.patches = builder.patches;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Each entry in the array is a structure containing:
     * </p>
     * <p>
     * Title (string)
     * </p>
     * <p>
     * KBId (string)
     * </p>
     * <p>
     * Classification (string)
     * </p>
     * <p>
     * Severity (string)
     * </p>
     * <p>
     * State (string: "INSTALLED", "INSTALLED OTHER", "MISSING", "NOT APPLICABLE", "FAILED")
     * </p>
     * <p>
     * InstalledTime (DateTime)
     * </p>
     * <p>
     * InstalledBy (string)
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Each entry in the array is a structure containing:</p>
     *         <p>
     *         Title (string)
     *         </p>
     *         <p>
     *         KBId (string)
     *         </p>
     *         <p>
     *         Classification (string)
     *         </p>
     *         <p>
     *         Severity (string)
     *         </p>
     *         <p>
     *         State (string: "INSTALLED", "INSTALLED OTHER", "MISSING", "NOT APPLICABLE", "FAILED")
     *         </p>
     *         <p>
     *         InstalledTime (DateTime)
     *         </p>
     *         <p>
     *         InstalledBy (string)
     */
    public List<PatchComplianceData> patches() {
        return patches;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(patches());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancePatchesResponse)) {
            return false;
        }
        DescribeInstancePatchesResponse other = (DescribeInstancePatchesResponse) obj;
        return Objects.equals(patches(), other.patches()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeInstancePatchesResponse").add("Patches", patches()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Patches":
            return Optional.of(clazz.cast(patches()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMResponse.Builder, CopyableBuilder<Builder, DescribeInstancePatchesResponse> {
        /**
         * <p>
         * Each entry in the array is a structure containing:
         * </p>
         * <p>
         * Title (string)
         * </p>
         * <p>
         * KBId (string)
         * </p>
         * <p>
         * Classification (string)
         * </p>
         * <p>
         * Severity (string)
         * </p>
         * <p>
         * State (string: "INSTALLED", "INSTALLED OTHER", "MISSING", "NOT APPLICABLE", "FAILED")
         * </p>
         * <p>
         * InstalledTime (DateTime)
         * </p>
         * <p>
         * InstalledBy (string)
         * </p>
         * 
         * @param patches
         *        Each entry in the array is a structure containing:</p>
         *        <p>
         *        Title (string)
         *        </p>
         *        <p>
         *        KBId (string)
         *        </p>
         *        <p>
         *        Classification (string)
         *        </p>
         *        <p>
         *        Severity (string)
         *        </p>
         *        <p>
         *        State (string: "INSTALLED", "INSTALLED OTHER", "MISSING", "NOT APPLICABLE", "FAILED")
         *        </p>
         *        <p>
         *        InstalledTime (DateTime)
         *        </p>
         *        <p>
         *        InstalledBy (string)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patches(Collection<PatchComplianceData> patches);

        /**
         * <p>
         * Each entry in the array is a structure containing:
         * </p>
         * <p>
         * Title (string)
         * </p>
         * <p>
         * KBId (string)
         * </p>
         * <p>
         * Classification (string)
         * </p>
         * <p>
         * Severity (string)
         * </p>
         * <p>
         * State (string: "INSTALLED", "INSTALLED OTHER", "MISSING", "NOT APPLICABLE", "FAILED")
         * </p>
         * <p>
         * InstalledTime (DateTime)
         * </p>
         * <p>
         * InstalledBy (string)
         * </p>
         * 
         * @param patches
         *        Each entry in the array is a structure containing:</p>
         *        <p>
         *        Title (string)
         *        </p>
         *        <p>
         *        KBId (string)
         *        </p>
         *        <p>
         *        Classification (string)
         *        </p>
         *        <p>
         *        Severity (string)
         *        </p>
         *        <p>
         *        State (string: "INSTALLED", "INSTALLED OTHER", "MISSING", "NOT APPLICABLE", "FAILED")
         *        </p>
         *        <p>
         *        InstalledTime (DateTime)
         *        </p>
         *        <p>
         *        InstalledBy (string)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patches(PatchComplianceData... patches);

        /**
         * <p>
         * Each entry in the array is a structure containing:
         * </p>
         * <p>
         * Title (string)
         * </p>
         * <p>
         * KBId (string)
         * </p>
         * <p>
         * Classification (string)
         * </p>
         * <p>
         * Severity (string)
         * </p>
         * <p>
         * State (string: "INSTALLED", "INSTALLED OTHER", "MISSING", "NOT APPLICABLE", "FAILED")
         * </p>
         * <p>
         * InstalledTime (DateTime)
         * </p>
         * <p>
         * InstalledBy (string)
         * </p>
         * This is a convenience that creates an instance of the {@link List<PatchComplianceData>.Builder} avoiding the
         * need to create one manually via {@link List<PatchComplianceData>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PatchComplianceData>.Builder#build()} is called immediately
         * and its result is passed to {@link #patches(List<PatchComplianceData>)}.
         * 
         * @param patches
         *        a consumer that will call methods on {@link List<PatchComplianceData>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #patches(List<PatchComplianceData>)
         */
        Builder patches(Consumer<PatchComplianceData.Builder>... patches);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SSMResponse.BuilderImpl implements Builder {
        private List<PatchComplianceData> patches;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancePatchesResponse model) {
            super(model);
            patches(model.patches);
            nextToken(model.nextToken);
        }

        public final Collection<PatchComplianceData.Builder> getPatches() {
            return patches != null ? patches.stream().map(PatchComplianceData::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder patches(Collection<PatchComplianceData> patches) {
            this.patches = PatchComplianceDataListCopier.copy(patches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patches(PatchComplianceData... patches) {
            patches(Arrays.asList(patches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patches(Consumer<PatchComplianceData.Builder>... patches) {
            patches(Stream.of(patches).map(c -> PatchComplianceData.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPatches(Collection<PatchComplianceData.BuilderImpl> patches) {
            this.patches = PatchComplianceDataListCopier.copyFromBuilder(patches);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeInstancePatchesResponse build() {
            return new DescribeInstancePatchesResponse(this);
        }
    }
}
