/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAvailablePatchesResponse extends SSMResponse implements
        ToCopyableBuilder<DescribeAvailablePatchesResponse.Builder, DescribeAvailablePatchesResponse> {
    private final List<Patch> patches;

    private final String nextToken;

    private DescribeAvailablePatchesResponse(BuilderImpl builder) {
        super(builder);
        this.patches = builder.patches;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An array of patches. Each entry in the array is a patch structure.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of patches. Each entry in the array is a patch structure.
     */
    public List<Patch> patches() {
        return patches;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(patches());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAvailablePatchesResponse)) {
            return false;
        }
        DescribeAvailablePatchesResponse other = (DescribeAvailablePatchesResponse) obj;
        return Objects.equals(patches(), other.patches()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeAvailablePatchesResponse").add("Patches", patches()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Patches":
            return Optional.of(clazz.cast(patches()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMResponse.Builder, CopyableBuilder<Builder, DescribeAvailablePatchesResponse> {
        /**
         * <p>
         * An array of patches. Each entry in the array is a patch structure.
         * </p>
         * 
         * @param patches
         *        An array of patches. Each entry in the array is a patch structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patches(Collection<Patch> patches);

        /**
         * <p>
         * An array of patches. Each entry in the array is a patch structure.
         * </p>
         * 
         * @param patches
         *        An array of patches. Each entry in the array is a patch structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patches(Patch... patches);

        /**
         * <p>
         * An array of patches. Each entry in the array is a patch structure.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Patch>.Builder} avoiding the need to create
         * one manually via {@link List<Patch>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Patch>.Builder#build()} is called immediately and its result
         * is passed to {@link #patches(List<Patch>)}.
         * 
         * @param patches
         *        a consumer that will call methods on {@link List<Patch>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #patches(List<Patch>)
         */
        Builder patches(Consumer<Patch.Builder>... patches);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SSMResponse.BuilderImpl implements Builder {
        private List<Patch> patches;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAvailablePatchesResponse model) {
            super(model);
            patches(model.patches);
            nextToken(model.nextToken);
        }

        public final Collection<Patch.Builder> getPatches() {
            return patches != null ? patches.stream().map(Patch::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder patches(Collection<Patch> patches) {
            this.patches = PatchListCopier.copy(patches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patches(Patch... patches) {
            patches(Arrays.asList(patches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patches(Consumer<Patch.Builder>... patches) {
            patches(Stream.of(patches).map(c -> Patch.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPatches(Collection<Patch.BuilderImpl> patches) {
            this.patches = PatchListCopier.copyFromBuilder(patches);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAvailablePatchesResponse build() {
            return new DescribeAvailablePatchesResponse(this);
        }
    }
}
