/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.EffectivePatch;

@SdkInternalApi
public class EffectivePatchMarshaller {
    private static final MarshallingInfo<StructuredPojo> PATCH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Patch").build();
    private static final MarshallingInfo<StructuredPojo> PATCHSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PatchStatus").build();
    private static final EffectivePatchMarshaller instance = new EffectivePatchMarshaller();

    public static EffectivePatchMarshaller getInstance() {
        return instance;
    }

    public void marshall(EffectivePatch effectivePatch, ProtocolMarshaller protocolMarshaller) {
        if (effectivePatch == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)effectivePatch.patch(), PATCH_BINDING);
            protocolMarshaller.marshall((Object)effectivePatch.patchStatus(), PATCHSTATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

