/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.Date;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.CommandPlugin;

@SdkInternalApi
public class CommandPluginMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> STATUSDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusDetails").build();
    private static final MarshallingInfo<Integer> RESPONSECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResponseCode").build();
    private static final MarshallingInfo<Date> RESPONSESTARTDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResponseStartDateTime").build();
    private static final MarshallingInfo<Date> RESPONSEFINISHDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResponseFinishDateTime").build();
    private static final MarshallingInfo<String> OUTPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Output").build();
    private static final MarshallingInfo<String> STANDARDOUTPUTURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StandardOutputUrl").build();
    private static final MarshallingInfo<String> STANDARDERRORURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StandardErrorUrl").build();
    private static final MarshallingInfo<String> OUTPUTS3REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputS3Region").build();
    private static final MarshallingInfo<String> OUTPUTS3BUCKETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputS3BucketName").build();
    private static final MarshallingInfo<String> OUTPUTS3KEYPREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputS3KeyPrefix").build();
    private static final CommandPluginMarshaller instance = new CommandPluginMarshaller();

    public static CommandPluginMarshaller getInstance() {
        return instance;
    }

    public void marshall(CommandPlugin commandPlugin, ProtocolMarshaller protocolMarshaller) {
        if (commandPlugin == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)commandPlugin.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)commandPlugin.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)commandPlugin.statusDetails(), STATUSDETAILS_BINDING);
            protocolMarshaller.marshall((Object)commandPlugin.responseCode(), RESPONSECODE_BINDING);
            protocolMarshaller.marshall((Object)commandPlugin.responseStartDateTime(), RESPONSESTARTDATETIME_BINDING);
            protocolMarshaller.marshall((Object)commandPlugin.responseFinishDateTime(), RESPONSEFINISHDATETIME_BINDING);
            protocolMarshaller.marshall((Object)commandPlugin.output(), OUTPUT_BINDING);
            protocolMarshaller.marshall((Object)commandPlugin.standardOutputUrl(), STANDARDOUTPUTURL_BINDING);
            protocolMarshaller.marshall((Object)commandPlugin.standardErrorUrl(), STANDARDERRORURL_BINDING);
            protocolMarshaller.marshall((Object)commandPlugin.outputS3Region(), OUTPUTS3REGION_BINDING);
            protocolMarshaller.marshall((Object)commandPlugin.outputS3BucketName(), OUTPUTS3BUCKETNAME_BINDING);
            protocolMarshaller.marshall((Object)commandPlugin.outputS3KeyPrefix(), OUTPUTS3KEYPREFIX_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

