/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ssm.model.DocumentHashType;
import software.amazon.awssdk.services.ssm.model.InstanceIdListCopier;
import software.amazon.awssdk.services.ssm.model.NotificationConfig;
import software.amazon.awssdk.services.ssm.model.ParametersCopier;
import software.amazon.awssdk.services.ssm.model.Target;
import software.amazon.awssdk.services.ssm.model.TargetsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SendCommandRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SendCommandRequest> {
    private final List<String> instanceIds;
    private final List<Target> targets;
    private final String documentName;
    private final String documentHash;
    private final String documentHashType;
    private final Integer timeoutSeconds;
    private final String comment;
    private final Map<String, List<String>> parameters;
    private final String outputS3Region;
    private final String outputS3BucketName;
    private final String outputS3KeyPrefix;
    private final String maxConcurrency;
    private final String maxErrors;
    private final String serviceRoleArn;
    private final NotificationConfig notificationConfig;

    private SendCommandRequest(BuilderImpl builder) {
        this.instanceIds = builder.instanceIds;
        this.targets = builder.targets;
        this.documentName = builder.documentName;
        this.documentHash = builder.documentHash;
        this.documentHashType = builder.documentHashType;
        this.timeoutSeconds = builder.timeoutSeconds;
        this.comment = builder.comment;
        this.parameters = builder.parameters;
        this.outputS3Region = builder.outputS3Region;
        this.outputS3BucketName = builder.outputS3BucketName;
        this.outputS3KeyPrefix = builder.outputS3KeyPrefix;
        this.maxConcurrency = builder.maxConcurrency;
        this.maxErrors = builder.maxErrors;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.notificationConfig = builder.notificationConfig;
    }

    public List<String> instanceIds() {
        return this.instanceIds;
    }

    public List<Target> targets() {
        return this.targets;
    }

    public String documentName() {
        return this.documentName;
    }

    public String documentHash() {
        return this.documentHash;
    }

    public String documentHashType() {
        return this.documentHashType;
    }

    public Integer timeoutSeconds() {
        return this.timeoutSeconds;
    }

    public String comment() {
        return this.comment;
    }

    public Map<String, List<String>> parameters() {
        return this.parameters;
    }

    public String outputS3Region() {
        return this.outputS3Region;
    }

    public String outputS3BucketName() {
        return this.outputS3BucketName;
    }

    public String outputS3KeyPrefix() {
        return this.outputS3KeyPrefix;
    }

    public String maxConcurrency() {
        return this.maxConcurrency;
    }

    public String maxErrors() {
        return this.maxErrors;
    }

    public String serviceRoleArn() {
        return this.serviceRoleArn;
    }

    public NotificationConfig notificationConfig() {
        return this.notificationConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceIds() == null ? 0 : this.instanceIds().hashCode());
        hashCode = 31 * hashCode + (this.targets() == null ? 0 : this.targets().hashCode());
        hashCode = 31 * hashCode + (this.documentName() == null ? 0 : this.documentName().hashCode());
        hashCode = 31 * hashCode + (this.documentHash() == null ? 0 : this.documentHash().hashCode());
        hashCode = 31 * hashCode + (this.documentHashType() == null ? 0 : this.documentHashType().hashCode());
        hashCode = 31 * hashCode + (this.timeoutSeconds() == null ? 0 : this.timeoutSeconds().hashCode());
        hashCode = 31 * hashCode + (this.comment() == null ? 0 : this.comment().hashCode());
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        hashCode = 31 * hashCode + (this.outputS3Region() == null ? 0 : this.outputS3Region().hashCode());
        hashCode = 31 * hashCode + (this.outputS3BucketName() == null ? 0 : this.outputS3BucketName().hashCode());
        hashCode = 31 * hashCode + (this.outputS3KeyPrefix() == null ? 0 : this.outputS3KeyPrefix().hashCode());
        hashCode = 31 * hashCode + (this.maxConcurrency() == null ? 0 : this.maxConcurrency().hashCode());
        hashCode = 31 * hashCode + (this.maxErrors() == null ? 0 : this.maxErrors().hashCode());
        hashCode = 31 * hashCode + (this.serviceRoleArn() == null ? 0 : this.serviceRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.notificationConfig() == null ? 0 : this.notificationConfig().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendCommandRequest)) {
            return false;
        }
        SendCommandRequest other = (SendCommandRequest)((Object)obj);
        if (other.instanceIds() == null ^ this.instanceIds() == null) {
            return false;
        }
        if (other.instanceIds() != null && !other.instanceIds().equals(this.instanceIds())) {
            return false;
        }
        if (other.targets() == null ^ this.targets() == null) {
            return false;
        }
        if (other.targets() != null && !other.targets().equals(this.targets())) {
            return false;
        }
        if (other.documentName() == null ^ this.documentName() == null) {
            return false;
        }
        if (other.documentName() != null && !other.documentName().equals(this.documentName())) {
            return false;
        }
        if (other.documentHash() == null ^ this.documentHash() == null) {
            return false;
        }
        if (other.documentHash() != null && !other.documentHash().equals(this.documentHash())) {
            return false;
        }
        if (other.documentHashType() == null ^ this.documentHashType() == null) {
            return false;
        }
        if (other.documentHashType() != null && !other.documentHashType().equals(this.documentHashType())) {
            return false;
        }
        if (other.timeoutSeconds() == null ^ this.timeoutSeconds() == null) {
            return false;
        }
        if (other.timeoutSeconds() != null && !other.timeoutSeconds().equals(this.timeoutSeconds())) {
            return false;
        }
        if (other.comment() == null ^ this.comment() == null) {
            return false;
        }
        if (other.comment() != null && !other.comment().equals(this.comment())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.outputS3Region() == null ^ this.outputS3Region() == null) {
            return false;
        }
        if (other.outputS3Region() != null && !other.outputS3Region().equals(this.outputS3Region())) {
            return false;
        }
        if (other.outputS3BucketName() == null ^ this.outputS3BucketName() == null) {
            return false;
        }
        if (other.outputS3BucketName() != null && !other.outputS3BucketName().equals(this.outputS3BucketName())) {
            return false;
        }
        if (other.outputS3KeyPrefix() == null ^ this.outputS3KeyPrefix() == null) {
            return false;
        }
        if (other.outputS3KeyPrefix() != null && !other.outputS3KeyPrefix().equals(this.outputS3KeyPrefix())) {
            return false;
        }
        if (other.maxConcurrency() == null ^ this.maxConcurrency() == null) {
            return false;
        }
        if (other.maxConcurrency() != null && !other.maxConcurrency().equals(this.maxConcurrency())) {
            return false;
        }
        if (other.maxErrors() == null ^ this.maxErrors() == null) {
            return false;
        }
        if (other.maxErrors() != null && !other.maxErrors().equals(this.maxErrors())) {
            return false;
        }
        if (other.serviceRoleArn() == null ^ this.serviceRoleArn() == null) {
            return false;
        }
        if (other.serviceRoleArn() != null && !other.serviceRoleArn().equals(this.serviceRoleArn())) {
            return false;
        }
        if (other.notificationConfig() == null ^ this.notificationConfig() == null) {
            return false;
        }
        return other.notificationConfig() == null || other.notificationConfig().equals(this.notificationConfig());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceIds() != null) {
            sb.append("InstanceIds: ").append(this.instanceIds()).append(",");
        }
        if (this.targets() != null) {
            sb.append("Targets: ").append(this.targets()).append(",");
        }
        if (this.documentName() != null) {
            sb.append("DocumentName: ").append(this.documentName()).append(",");
        }
        if (this.documentHash() != null) {
            sb.append("DocumentHash: ").append(this.documentHash()).append(",");
        }
        if (this.documentHashType() != null) {
            sb.append("DocumentHashType: ").append(this.documentHashType()).append(",");
        }
        if (this.timeoutSeconds() != null) {
            sb.append("TimeoutSeconds: ").append(this.timeoutSeconds()).append(",");
        }
        if (this.comment() != null) {
            sb.append("Comment: ").append(this.comment()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (this.outputS3Region() != null) {
            sb.append("OutputS3Region: ").append(this.outputS3Region()).append(",");
        }
        if (this.outputS3BucketName() != null) {
            sb.append("OutputS3BucketName: ").append(this.outputS3BucketName()).append(",");
        }
        if (this.outputS3KeyPrefix() != null) {
            sb.append("OutputS3KeyPrefix: ").append(this.outputS3KeyPrefix()).append(",");
        }
        if (this.maxConcurrency() != null) {
            sb.append("MaxConcurrency: ").append(this.maxConcurrency()).append(",");
        }
        if (this.maxErrors() != null) {
            sb.append("MaxErrors: ").append(this.maxErrors()).append(",");
        }
        if (this.serviceRoleArn() != null) {
            sb.append("ServiceRoleArn: ").append(this.serviceRoleArn()).append(",");
        }
        if (this.notificationConfig() != null) {
            sb.append("NotificationConfig: ").append(this.notificationConfig()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> instanceIds = new SdkInternalList();
        private List<Target> targets = new SdkInternalList();
        private String documentName;
        private String documentHash;
        private String documentHashType;
        private Integer timeoutSeconds;
        private String comment;
        private Map<String, List<String>> parameters;
        private String outputS3Region;
        private String outputS3BucketName;
        private String outputS3KeyPrefix;
        private String maxConcurrency;
        private String maxErrors;
        private String serviceRoleArn;
        private NotificationConfig notificationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(SendCommandRequest model) {
            this.setInstanceIds(model.instanceIds);
            this.setTargets(model.targets);
            this.setDocumentName(model.documentName);
            this.setDocumentHash(model.documentHash);
            this.setDocumentHashType(model.documentHashType);
            this.setTimeoutSeconds(model.timeoutSeconds);
            this.setComment(model.comment);
            this.setParameters(model.parameters);
            this.setOutputS3Region(model.outputS3Region);
            this.setOutputS3BucketName(model.outputS3BucketName);
            this.setOutputS3KeyPrefix(model.outputS3KeyPrefix);
            this.setMaxConcurrency(model.maxConcurrency);
            this.setMaxErrors(model.maxErrors);
            this.setServiceRoleArn(model.serviceRoleArn);
            this.setNotificationConfig(model.notificationConfig);
        }

        public final Collection<String> getInstanceIds() {
            return this.instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdListCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String ... instanceIds) {
            if (this.instanceIds == null) {
                this.instanceIds = new SdkInternalList(instanceIds.length);
            }
            for (String e : instanceIds) {
                this.instanceIds.add(e);
            }
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdListCopier.copy(instanceIds);
        }

        @SafeVarargs
        public final void setInstanceIds(String ... instanceIds) {
            if (this.instanceIds == null) {
                this.instanceIds = new SdkInternalList(instanceIds.length);
            }
            for (String e : instanceIds) {
                this.instanceIds.add(e);
            }
        }

        public final Collection<Target> getTargets() {
            return this.targets;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            if (this.targets == null) {
                this.targets = new SdkInternalList(targets.length);
            }
            for (Target e : targets) {
                this.targets.add(e);
            }
            return this;
        }

        public final void setTargets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
        }

        @SafeVarargs
        public final void setTargets(Target ... targets) {
            if (this.targets == null) {
                this.targets = new SdkInternalList(targets.length);
            }
            for (Target e : targets) {
                this.targets.add(e);
            }
        }

        public final String getDocumentName() {
            return this.documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        public final String getDocumentHash() {
            return this.documentHash;
        }

        @Override
        public final Builder documentHash(String documentHash) {
            this.documentHash = documentHash;
            return this;
        }

        public final void setDocumentHash(String documentHash) {
            this.documentHash = documentHash;
        }

        public final String getDocumentHashType() {
            return this.documentHashType;
        }

        @Override
        public final Builder documentHashType(String documentHashType) {
            this.documentHashType = documentHashType;
            return this;
        }

        @Override
        public final Builder documentHashType(DocumentHashType documentHashType) {
            this.documentHashType(documentHashType.toString());
            return this;
        }

        public final void setDocumentHashType(String documentHashType) {
            this.documentHashType = documentHashType;
        }

        public final void setDocumentHashType(DocumentHashType documentHashType) {
            this.documentHashType(documentHashType.toString());
        }

        public final Integer getTimeoutSeconds() {
            return this.timeoutSeconds;
        }

        @Override
        public final Builder timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public final void setTimeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
        }

        public final String getOutputS3Region() {
            return this.outputS3Region;
        }

        @Override
        public final Builder outputS3Region(String outputS3Region) {
            this.outputS3Region = outputS3Region;
            return this;
        }

        public final void setOutputS3Region(String outputS3Region) {
            this.outputS3Region = outputS3Region;
        }

        public final String getOutputS3BucketName() {
            return this.outputS3BucketName;
        }

        @Override
        public final Builder outputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
            return this;
        }

        public final void setOutputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
        }

        public final String getOutputS3KeyPrefix() {
            return this.outputS3KeyPrefix;
        }

        @Override
        public final Builder outputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
            return this;
        }

        public final void setOutputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
        }

        public final String getMaxConcurrency() {
            return this.maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        public final String getMaxErrors() {
            return this.maxErrors;
        }

        @Override
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        public final String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final NotificationConfig getNotificationConfig() {
            return this.notificationConfig;
        }

        @Override
        public final Builder notificationConfig(NotificationConfig notificationConfig) {
            this.notificationConfig = notificationConfig;
            return this;
        }

        public final void setNotificationConfig(NotificationConfig notificationConfig) {
            this.notificationConfig = notificationConfig;
        }

        public SendCommandRequest build() {
            return new SendCommandRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SendCommandRequest> {
        public Builder instanceIds(Collection<String> var1);

        public Builder instanceIds(String ... var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder documentName(String var1);

        public Builder documentHash(String var1);

        public Builder documentHashType(String var1);

        public Builder documentHashType(DocumentHashType var1);

        public Builder timeoutSeconds(Integer var1);

        public Builder comment(String var1);

        public Builder parameters(Map<String, ? extends Collection<String>> var1);

        public Builder outputS3Region(String var1);

        public Builder outputS3BucketName(String var1);

        public Builder outputS3KeyPrefix(String var1);

        public Builder maxConcurrency(String var1);

        public Builder maxErrors(String var1);

        public Builder serviceRoleArn(String var1);

        public Builder notificationConfig(NotificationConfig var1);
    }
}

