/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.S3OutputLocationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class S3OutputLocation
implements StructuredPojo,
ToCopyableBuilder<Builder, S3OutputLocation> {
    private final String outputS3Region;
    private final String outputS3BucketName;
    private final String outputS3KeyPrefix;

    private S3OutputLocation(BuilderImpl builder) {
        this.outputS3Region = builder.outputS3Region;
        this.outputS3BucketName = builder.outputS3BucketName;
        this.outputS3KeyPrefix = builder.outputS3KeyPrefix;
    }

    public String outputS3Region() {
        return this.outputS3Region;
    }

    public String outputS3BucketName() {
        return this.outputS3BucketName;
    }

    public String outputS3KeyPrefix() {
        return this.outputS3KeyPrefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.outputS3Region() == null ? 0 : this.outputS3Region().hashCode());
        hashCode = 31 * hashCode + (this.outputS3BucketName() == null ? 0 : this.outputS3BucketName().hashCode());
        hashCode = 31 * hashCode + (this.outputS3KeyPrefix() == null ? 0 : this.outputS3KeyPrefix().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3OutputLocation)) {
            return false;
        }
        S3OutputLocation other = (S3OutputLocation)obj;
        if (other.outputS3Region() == null ^ this.outputS3Region() == null) {
            return false;
        }
        if (other.outputS3Region() != null && !other.outputS3Region().equals(this.outputS3Region())) {
            return false;
        }
        if (other.outputS3BucketName() == null ^ this.outputS3BucketName() == null) {
            return false;
        }
        if (other.outputS3BucketName() != null && !other.outputS3BucketName().equals(this.outputS3BucketName())) {
            return false;
        }
        if (other.outputS3KeyPrefix() == null ^ this.outputS3KeyPrefix() == null) {
            return false;
        }
        return other.outputS3KeyPrefix() == null || other.outputS3KeyPrefix().equals(this.outputS3KeyPrefix());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.outputS3Region() != null) {
            sb.append("OutputS3Region: ").append(this.outputS3Region()).append(",");
        }
        if (this.outputS3BucketName() != null) {
            sb.append("OutputS3BucketName: ").append(this.outputS3BucketName()).append(",");
        }
        if (this.outputS3KeyPrefix() != null) {
            sb.append("OutputS3KeyPrefix: ").append(this.outputS3KeyPrefix()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3OutputLocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String outputS3Region;
        private String outputS3BucketName;
        private String outputS3KeyPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(S3OutputLocation model) {
            this.setOutputS3Region(model.outputS3Region);
            this.setOutputS3BucketName(model.outputS3BucketName);
            this.setOutputS3KeyPrefix(model.outputS3KeyPrefix);
        }

        public final String getOutputS3Region() {
            return this.outputS3Region;
        }

        @Override
        public final Builder outputS3Region(String outputS3Region) {
            this.outputS3Region = outputS3Region;
            return this;
        }

        public final void setOutputS3Region(String outputS3Region) {
            this.outputS3Region = outputS3Region;
        }

        public final String getOutputS3BucketName() {
            return this.outputS3BucketName;
        }

        @Override
        public final Builder outputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
            return this;
        }

        public final void setOutputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
        }

        public final String getOutputS3KeyPrefix() {
            return this.outputS3KeyPrefix;
        }

        @Override
        public final Builder outputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
            return this;
        }

        public final void setOutputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
        }

        public S3OutputLocation build() {
            return new S3OutputLocation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, S3OutputLocation> {
        public Builder outputS3Region(String var1);

        public Builder outputS3BucketName(String var1);

        public Builder outputS3KeyPrefix(String var1);
    }
}

