/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.ssm.model.ParameterType;
import software.amazon.awssdk.services.ssm.transform.ParameterHistoryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ParameterHistory
implements StructuredPojo,
ToCopyableBuilder<Builder, ParameterHistory> {
    private final String name;
    private final String type;
    private final String keyId;
    private final Date lastModifiedDate;
    private final String lastModifiedUser;
    private final String description;
    private final String value;
    private final String allowedPattern;

    private ParameterHistory(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.keyId = builder.keyId;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.lastModifiedUser = builder.lastModifiedUser;
        this.description = builder.description;
        this.value = builder.value;
        this.allowedPattern = builder.allowedPattern;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public String keyId() {
        return this.keyId;
    }

    public Date lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public String lastModifiedUser() {
        return this.lastModifiedUser;
    }

    public String description() {
        return this.description;
    }

    public String value() {
        return this.value;
    }

    public String allowedPattern() {
        return this.allowedPattern;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.keyId() == null ? 0 : this.keyId().hashCode());
        hashCode = 31 * hashCode + (this.lastModifiedDate() == null ? 0 : this.lastModifiedDate().hashCode());
        hashCode = 31 * hashCode + (this.lastModifiedUser() == null ? 0 : this.lastModifiedUser().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.value() == null ? 0 : this.value().hashCode());
        hashCode = 31 * hashCode + (this.allowedPattern() == null ? 0 : this.allowedPattern().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterHistory)) {
            return false;
        }
        ParameterHistory other = (ParameterHistory)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        if (other.keyId() != null && !other.keyId().equals(this.keyId())) {
            return false;
        }
        if (other.lastModifiedDate() == null ^ this.lastModifiedDate() == null) {
            return false;
        }
        if (other.lastModifiedDate() != null && !other.lastModifiedDate().equals(this.lastModifiedDate())) {
            return false;
        }
        if (other.lastModifiedUser() == null ^ this.lastModifiedUser() == null) {
            return false;
        }
        if (other.lastModifiedUser() != null && !other.lastModifiedUser().equals(this.lastModifiedUser())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.value() == null ^ this.value() == null) {
            return false;
        }
        if (other.value() != null && !other.value().equals(this.value())) {
            return false;
        }
        if (other.allowedPattern() == null ^ this.allowedPattern() == null) {
            return false;
        }
        return other.allowedPattern() == null || other.allowedPattern().equals(this.allowedPattern());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.keyId() != null) {
            sb.append("KeyId: ").append(this.keyId()).append(",");
        }
        if (this.lastModifiedDate() != null) {
            sb.append("LastModifiedDate: ").append(this.lastModifiedDate()).append(",");
        }
        if (this.lastModifiedUser() != null) {
            sb.append("LastModifiedUser: ").append(this.lastModifiedUser()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.value() != null) {
            sb.append("Value: ").append(this.value()).append(",");
        }
        if (this.allowedPattern() != null) {
            sb.append("AllowedPattern: ").append(this.allowedPattern()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ParameterHistoryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String type;
        private String keyId;
        private Date lastModifiedDate;
        private String lastModifiedUser;
        private String description;
        private String value;
        private String allowedPattern;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterHistory model) {
            this.setName(model.name);
            this.setType(model.type);
            this.setKeyId(model.keyId);
            this.setLastModifiedDate(model.lastModifiedDate);
            this.setLastModifiedUser(model.lastModifiedUser);
            this.setDescription(model.description);
            this.setValue(model.value);
            this.setAllowedPattern(model.allowedPattern);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ParameterType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(ParameterType type) {
            this.type(type.toString());
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final Date getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Date lastModifiedDate) {
            this.lastModifiedDate = StandardMemberCopier.copy((Date)lastModifiedDate);
            return this;
        }

        public final void setLastModifiedDate(Date lastModifiedDate) {
            this.lastModifiedDate = StandardMemberCopier.copy((Date)lastModifiedDate);
        }

        public final String getLastModifiedUser() {
            return this.lastModifiedUser;
        }

        @Override
        public final Builder lastModifiedUser(String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
            return this;
        }

        public final void setLastModifiedUser(String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getAllowedPattern() {
            return this.allowedPattern;
        }

        @Override
        public final Builder allowedPattern(String allowedPattern) {
            this.allowedPattern = allowedPattern;
            return this;
        }

        public final void setAllowedPattern(String allowedPattern) {
            this.allowedPattern = allowedPattern;
        }

        public ParameterHistory build() {
            return new ParameterHistory(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ParameterHistory> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(ParameterType var1);

        public Builder keyId(String var1);

        public Builder lastModifiedDate(Date var1);

        public Builder lastModifiedUser(String var1);

        public Builder description(String var1);

        public Builder value(String var1);

        public Builder allowedPattern(String var1);
    }
}

