/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ssm.model.InventoryItemEntryCopier;
import software.amazon.awssdk.services.ssm.model.InventoryItemEntryListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListInventoryEntriesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListInventoryEntriesResponse> {
    private final String typeName;
    private final String instanceId;
    private final String schemaVersion;
    private final String captureTime;
    private final List<Map<String, String>> entries;
    private final String nextToken;

    private ListInventoryEntriesResponse(BuilderImpl builder) {
        this.typeName = builder.typeName;
        this.instanceId = builder.instanceId;
        this.schemaVersion = builder.schemaVersion;
        this.captureTime = builder.captureTime;
        this.entries = builder.entries;
        this.nextToken = builder.nextToken;
    }

    public String typeName() {
        return this.typeName;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String schemaVersion() {
        return this.schemaVersion;
    }

    public String captureTime() {
        return this.captureTime;
    }

    public List<Map<String, String>> entries() {
        return this.entries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.typeName() == null ? 0 : this.typeName().hashCode());
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.schemaVersion() == null ? 0 : this.schemaVersion().hashCode());
        hashCode = 31 * hashCode + (this.captureTime() == null ? 0 : this.captureTime().hashCode());
        hashCode = 31 * hashCode + (this.entries() == null ? 0 : this.entries().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInventoryEntriesResponse)) {
            return false;
        }
        ListInventoryEntriesResponse other = (ListInventoryEntriesResponse)((Object)obj);
        if (other.typeName() == null ^ this.typeName() == null) {
            return false;
        }
        if (other.typeName() != null && !other.typeName().equals(this.typeName())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.schemaVersion() == null ^ this.schemaVersion() == null) {
            return false;
        }
        if (other.schemaVersion() != null && !other.schemaVersion().equals(this.schemaVersion())) {
            return false;
        }
        if (other.captureTime() == null ^ this.captureTime() == null) {
            return false;
        }
        if (other.captureTime() != null && !other.captureTime().equals(this.captureTime())) {
            return false;
        }
        if (other.entries() == null ^ this.entries() == null) {
            return false;
        }
        if (other.entries() != null && !other.entries().equals(this.entries())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.typeName() != null) {
            sb.append("TypeName: ").append(this.typeName()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.schemaVersion() != null) {
            sb.append("SchemaVersion: ").append(this.schemaVersion()).append(",");
        }
        if (this.captureTime() != null) {
            sb.append("CaptureTime: ").append(this.captureTime()).append(",");
        }
        if (this.entries() != null) {
            sb.append("Entries: ").append(this.entries()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String typeName;
        private String instanceId;
        private String schemaVersion;
        private String captureTime;
        private List<Map<String, String>> entries = new SdkInternalList();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInventoryEntriesResponse model) {
            this.setTypeName(model.typeName);
            this.setInstanceId(model.instanceId);
            this.setSchemaVersion(model.schemaVersion);
            this.setCaptureTime(model.captureTime);
            this.setEntries(model.entries);
            this.setNextToken(model.nextToken);
        }

        public final String getTypeName() {
            return this.typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getSchemaVersion() {
            return this.schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        public final String getCaptureTime() {
            return this.captureTime;
        }

        @Override
        public final Builder captureTime(String captureTime) {
            this.captureTime = captureTime;
            return this;
        }

        public final void setCaptureTime(String captureTime) {
            this.captureTime = captureTime;
        }

        public final Collection<Map<String, String>> getEntries() {
            return this.entries;
        }

        @Override
        public final Builder entries(Collection<Map<String, String>> entries) {
            this.entries = InventoryItemEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Map<String, String> ... entries) {
            if (this.entries == null) {
                this.entries = new SdkInternalList(entries.length);
            }
            for (Map<String, String> e : entries) {
                this.entries.add(InventoryItemEntryCopier.copy(e));
            }
            return this;
        }

        public final void setEntries(Collection<Map<String, String>> entries) {
            this.entries = InventoryItemEntryListCopier.copy(entries);
        }

        @SafeVarargs
        public final void setEntries(Map<String, String> ... entries) {
            if (this.entries == null) {
                this.entries = new SdkInternalList(entries.length);
            }
            for (Map<String, String> e : entries) {
                this.entries.add(InventoryItemEntryCopier.copy(e));
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListInventoryEntriesResponse build() {
            return new ListInventoryEntriesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListInventoryEntriesResponse> {
        public Builder typeName(String var1);

        public Builder instanceId(String var1);

        public Builder schemaVersion(String var1);

        public Builder captureTime(String var1);

        public Builder entries(Collection<Map<String, String>> var1);

        public Builder entries(Map<String, String> ... var1);

        public Builder nextToken(String var1);
    }
}

