/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ssm.model.InventoryFilter;
import software.amazon.awssdk.services.ssm.model.InventoryFilterListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListInventoryEntriesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListInventoryEntriesRequest> {
    private final String instanceId;
    private final String typeName;
    private final List<InventoryFilter> filters;
    private final String nextToken;
    private final Integer maxResults;

    private ListInventoryEntriesRequest(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.typeName = builder.typeName;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String typeName() {
        return this.typeName;
    }

    public List<InventoryFilter> filters() {
        return this.filters;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.typeName() == null ? 0 : this.typeName().hashCode());
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInventoryEntriesRequest)) {
            return false;
        }
        ListInventoryEntriesRequest other = (ListInventoryEntriesRequest)((Object)obj);
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.typeName() == null ^ this.typeName() == null) {
            return false;
        }
        if (other.typeName() != null && !other.typeName().equals(this.typeName())) {
            return false;
        }
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        return other.maxResults() == null || other.maxResults().equals(this.maxResults());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.typeName() != null) {
            sb.append("TypeName: ").append(this.typeName()).append(",");
        }
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String typeName;
        private List<InventoryFilter> filters = new SdkInternalList();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInventoryEntriesRequest model) {
            this.setInstanceId(model.instanceId);
            this.setTypeName(model.typeName);
            this.setFilters(model.filters);
            this.setNextToken(model.nextToken);
            this.setMaxResults(model.maxResults);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final Collection<InventoryFilter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<InventoryFilter> filters) {
            this.filters = InventoryFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(InventoryFilter ... filters) {
            if (this.filters == null) {
                this.filters = new SdkInternalList(filters.length);
            }
            for (InventoryFilter e : filters) {
                this.filters.add(e);
            }
            return this;
        }

        public final void setFilters(Collection<InventoryFilter> filters) {
            this.filters = InventoryFilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(InventoryFilter ... filters) {
            if (this.filters == null) {
                this.filters = new SdkInternalList(filters.length);
            }
            for (InventoryFilter e : filters) {
                this.filters.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public ListInventoryEntriesRequest build() {
            return new ListInventoryEntriesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListInventoryEntriesRequest> {
        public Builder instanceId(String var1);

        public Builder typeName(String var1);

        public Builder filters(Collection<InventoryFilter> var1);

        public Builder filters(InventoryFilter ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);
    }
}

