/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.InventoryResultItem;
import software.amazon.awssdk.services.ssm.model.InventoryResultItemMapCopier;
import software.amazon.awssdk.services.ssm.transform.InventoryResultEntityMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InventoryResultEntity
implements StructuredPojo,
ToCopyableBuilder<Builder, InventoryResultEntity> {
    private final String id;
    private final Map<String, InventoryResultItem> data;

    private InventoryResultEntity(BuilderImpl builder) {
        this.id = builder.id;
        this.data = builder.data;
    }

    public String id() {
        return this.id;
    }

    public Map<String, InventoryResultItem> data() {
        return this.data;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.data() == null ? 0 : this.data().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryResultEntity)) {
            return false;
        }
        InventoryResultEntity other = (InventoryResultEntity)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.data() == null ^ this.data() == null) {
            return false;
        }
        return other.data() == null || other.data().equals(this.data());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.data() != null) {
            sb.append("Data: ").append(this.data()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InventoryResultEntityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private Map<String, InventoryResultItem> data;

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryResultEntity model) {
            this.setId(model.id);
            this.setData(model.data);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Map<String, InventoryResultItem> getData() {
            return this.data;
        }

        @Override
        public final Builder data(Map<String, InventoryResultItem> data) {
            this.data = InventoryResultItemMapCopier.copy(data);
            return this;
        }

        public final void setData(Map<String, InventoryResultItem> data) {
            this.data = InventoryResultItemMapCopier.copy(data);
        }

        public InventoryResultEntity build() {
            return new InventoryResultEntity(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InventoryResultEntity> {
        public Builder id(String var1);

        public Builder data(Map<String, InventoryResultItem> var1);
    }
}

