/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ssm.model.ParameterMetadata;
import software.amazon.awssdk.services.ssm.model.ParameterMetadataListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeParametersResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeParametersResponse> {
    private final List<ParameterMetadata> parameters;
    private final String nextToken;

    private DescribeParametersResponse(BuilderImpl builder) {
        this.parameters = builder.parameters;
        this.nextToken = builder.nextToken;
    }

    public List<ParameterMetadata> parameters() {
        return this.parameters;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeParametersResponse)) {
            return false;
        }
        DescribeParametersResponse other = (DescribeParametersResponse)((Object)obj);
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ParameterMetadata> parameters = new SdkInternalList();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeParametersResponse model) {
            this.setParameters(model.parameters);
            this.setNextToken(model.nextToken);
        }

        public final Collection<ParameterMetadata> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Collection<ParameterMetadata> parameters) {
            this.parameters = ParameterMetadataListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(ParameterMetadata ... parameters) {
            if (this.parameters == null) {
                this.parameters = new SdkInternalList(parameters.length);
            }
            for (ParameterMetadata e : parameters) {
                this.parameters.add(e);
            }
            return this;
        }

        public final void setParameters(Collection<ParameterMetadata> parameters) {
            this.parameters = ParameterMetadataListCopier.copy(parameters);
        }

        @SafeVarargs
        public final void setParameters(ParameterMetadata ... parameters) {
            if (this.parameters == null) {
                this.parameters = new SdkInternalList(parameters.length);
            }
            for (ParameterMetadata e : parameters) {
                this.parameters.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeParametersResponse build() {
            return new DescribeParametersResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeParametersResponse> {
        public Builder parameters(Collection<ParameterMetadata> var1);

        public Builder parameters(ParameterMetadata ... var1);

        public Builder nextToken(String var1);
    }
}

