/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ssm.model.AccountIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDocumentPermissionResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeDocumentPermissionResponse> {
    private final List<String> accountIds;

    private DescribeDocumentPermissionResponse(BuilderImpl builder) {
        this.accountIds = builder.accountIds;
    }

    public List<String> accountIds() {
        return this.accountIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.accountIds() == null ? 0 : this.accountIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDocumentPermissionResponse)) {
            return false;
        }
        DescribeDocumentPermissionResponse other = (DescribeDocumentPermissionResponse)((Object)obj);
        if (other.accountIds() == null ^ this.accountIds() == null) {
            return false;
        }
        return other.accountIds() == null || other.accountIds().equals(this.accountIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.accountIds() != null) {
            sb.append("AccountIds: ").append(this.accountIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> accountIds = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDocumentPermissionResponse model) {
            this.setAccountIds(model.accountIds);
        }

        public final Collection<String> getAccountIds() {
            return this.accountIds;
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdListCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String ... accountIds) {
            if (this.accountIds == null) {
                this.accountIds = new SdkInternalList(accountIds.length);
            }
            for (String e : accountIds) {
                this.accountIds.add(e);
            }
            return this;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdListCopier.copy(accountIds);
        }

        @SafeVarargs
        public final void setAccountIds(String ... accountIds) {
            if (this.accountIds == null) {
                this.accountIds = new SdkInternalList(accountIds.length);
            }
            for (String e : accountIds) {
                this.accountIds.add(e);
            }
        }

        public DescribeDocumentPermissionResponse build() {
            return new DescribeDocumentPermissionResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeDocumentPermissionResponse> {
        public Builder accountIds(Collection<String> var1);

        public Builder accountIds(String ... var1);
    }
}

