/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ssm.model.Activation;
import software.amazon.awssdk.services.ssm.model.ActivationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeActivationsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeActivationsResponse> {
    private final List<Activation> activationList;
    private final String nextToken;

    private DescribeActivationsResponse(BuilderImpl builder) {
        this.activationList = builder.activationList;
        this.nextToken = builder.nextToken;
    }

    public List<Activation> activationList() {
        return this.activationList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.activationList() == null ? 0 : this.activationList().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeActivationsResponse)) {
            return false;
        }
        DescribeActivationsResponse other = (DescribeActivationsResponse)((Object)obj);
        if (other.activationList() == null ^ this.activationList() == null) {
            return false;
        }
        if (other.activationList() != null && !other.activationList().equals(this.activationList())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.activationList() != null) {
            sb.append("ActivationList: ").append(this.activationList()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Activation> activationList = new SdkInternalList();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeActivationsResponse model) {
            this.setActivationList(model.activationList);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Activation> getActivationList() {
            return this.activationList;
        }

        @Override
        public final Builder activationList(Collection<Activation> activationList) {
            this.activationList = ActivationListCopier.copy(activationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activationList(Activation ... activationList) {
            if (this.activationList == null) {
                this.activationList = new SdkInternalList(activationList.length);
            }
            for (Activation e : activationList) {
                this.activationList.add(e);
            }
            return this;
        }

        public final void setActivationList(Collection<Activation> activationList) {
            this.activationList = ActivationListCopier.copy(activationList);
        }

        @SafeVarargs
        public final void setActivationList(Activation ... activationList) {
            if (this.activationList == null) {
                this.activationList = new SdkInternalList(activationList.length);
            }
            for (Activation e : activationList) {
                this.activationList.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeActivationsResponse build() {
            return new DescribeActivationsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeActivationsResponse> {
        public Builder activationList(Collection<Activation> var1);

        public Builder activationList(Activation ... var1);

        public Builder nextToken(String var1);
    }
}

