/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ssm.model.DescribeActivationsFilterKeys;
import software.amazon.awssdk.services.ssm.model.StringListCopier;
import software.amazon.awssdk.services.ssm.transform.DescribeActivationsFilterMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeActivationsFilter
implements StructuredPojo,
ToCopyableBuilder<Builder, DescribeActivationsFilter> {
    private final String filterKey;
    private final List<String> filterValues;

    private DescribeActivationsFilter(BuilderImpl builder) {
        this.filterKey = builder.filterKey;
        this.filterValues = builder.filterValues;
    }

    public String filterKey() {
        return this.filterKey;
    }

    public List<String> filterValues() {
        return this.filterValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.filterKey() == null ? 0 : this.filterKey().hashCode());
        hashCode = 31 * hashCode + (this.filterValues() == null ? 0 : this.filterValues().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeActivationsFilter)) {
            return false;
        }
        DescribeActivationsFilter other = (DescribeActivationsFilter)obj;
        if (other.filterKey() == null ^ this.filterKey() == null) {
            return false;
        }
        if (other.filterKey() != null && !other.filterKey().equals(this.filterKey())) {
            return false;
        }
        if (other.filterValues() == null ^ this.filterValues() == null) {
            return false;
        }
        return other.filterValues() == null || other.filterValues().equals(this.filterValues());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filterKey() != null) {
            sb.append("FilterKey: ").append(this.filterKey()).append(",");
        }
        if (this.filterValues() != null) {
            sb.append("FilterValues: ").append(this.filterValues()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DescribeActivationsFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String filterKey;
        private List<String> filterValues = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeActivationsFilter model) {
            this.setFilterKey(model.filterKey);
            this.setFilterValues(model.filterValues);
        }

        public final String getFilterKey() {
            return this.filterKey;
        }

        @Override
        public final Builder filterKey(String filterKey) {
            this.filterKey = filterKey;
            return this;
        }

        @Override
        public final Builder filterKey(DescribeActivationsFilterKeys filterKey) {
            this.filterKey(filterKey.toString());
            return this;
        }

        public final void setFilterKey(String filterKey) {
            this.filterKey = filterKey;
        }

        public final void setFilterKey(DescribeActivationsFilterKeys filterKey) {
            this.filterKey(filterKey.toString());
        }

        public final Collection<String> getFilterValues() {
            return this.filterValues;
        }

        @Override
        public final Builder filterValues(Collection<String> filterValues) {
            this.filterValues = StringListCopier.copy(filterValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterValues(String ... filterValues) {
            if (this.filterValues == null) {
                this.filterValues = new SdkInternalList(filterValues.length);
            }
            for (String e : filterValues) {
                this.filterValues.add(e);
            }
            return this;
        }

        public final void setFilterValues(Collection<String> filterValues) {
            this.filterValues = StringListCopier.copy(filterValues);
        }

        @SafeVarargs
        public final void setFilterValues(String ... filterValues) {
            if (this.filterValues == null) {
                this.filterValues = new SdkInternalList(filterValues.length);
            }
            for (String e : filterValues) {
                this.filterValues.add(e);
            }
        }

        public DescribeActivationsFilter build() {
            return new DescribeActivationsFilter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeActivationsFilter> {
        public Builder filterKey(String var1);

        public Builder filterKey(DescribeActivationsFilterKeys var1);

        public Builder filterValues(Collection<String> var1);

        public Builder filterValues(String ... var1);
    }
}

