/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus;
import software.amazon.awssdk.services.ssm.model.AutomationParameterMapCopier;
import software.amazon.awssdk.services.ssm.transform.AutomationExecutionMetadataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AutomationExecutionMetadata
implements StructuredPojo,
ToCopyableBuilder<Builder, AutomationExecutionMetadata> {
    private final String automationExecutionId;
    private final String documentName;
    private final String documentVersion;
    private final String automationExecutionStatus;
    private final Date executionStartTime;
    private final Date executionEndTime;
    private final String executedBy;
    private final String logFile;
    private final Map<String, List<String>> outputs;

    private AutomationExecutionMetadata(BuilderImpl builder) {
        this.automationExecutionId = builder.automationExecutionId;
        this.documentName = builder.documentName;
        this.documentVersion = builder.documentVersion;
        this.automationExecutionStatus = builder.automationExecutionStatus;
        this.executionStartTime = builder.executionStartTime;
        this.executionEndTime = builder.executionEndTime;
        this.executedBy = builder.executedBy;
        this.logFile = builder.logFile;
        this.outputs = builder.outputs;
    }

    public String automationExecutionId() {
        return this.automationExecutionId;
    }

    public String documentName() {
        return this.documentName;
    }

    public String documentVersion() {
        return this.documentVersion;
    }

    public String automationExecutionStatus() {
        return this.automationExecutionStatus;
    }

    public Date executionStartTime() {
        return this.executionStartTime;
    }

    public Date executionEndTime() {
        return this.executionEndTime;
    }

    public String executedBy() {
        return this.executedBy;
    }

    public String logFile() {
        return this.logFile;
    }

    public Map<String, List<String>> outputs() {
        return this.outputs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.automationExecutionId() == null ? 0 : this.automationExecutionId().hashCode());
        hashCode = 31 * hashCode + (this.documentName() == null ? 0 : this.documentName().hashCode());
        hashCode = 31 * hashCode + (this.documentVersion() == null ? 0 : this.documentVersion().hashCode());
        hashCode = 31 * hashCode + (this.automationExecutionStatus() == null ? 0 : this.automationExecutionStatus().hashCode());
        hashCode = 31 * hashCode + (this.executionStartTime() == null ? 0 : this.executionStartTime().hashCode());
        hashCode = 31 * hashCode + (this.executionEndTime() == null ? 0 : this.executionEndTime().hashCode());
        hashCode = 31 * hashCode + (this.executedBy() == null ? 0 : this.executedBy().hashCode());
        hashCode = 31 * hashCode + (this.logFile() == null ? 0 : this.logFile().hashCode());
        hashCode = 31 * hashCode + (this.outputs() == null ? 0 : this.outputs().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationExecutionMetadata)) {
            return false;
        }
        AutomationExecutionMetadata other = (AutomationExecutionMetadata)obj;
        if (other.automationExecutionId() == null ^ this.automationExecutionId() == null) {
            return false;
        }
        if (other.automationExecutionId() != null && !other.automationExecutionId().equals(this.automationExecutionId())) {
            return false;
        }
        if (other.documentName() == null ^ this.documentName() == null) {
            return false;
        }
        if (other.documentName() != null && !other.documentName().equals(this.documentName())) {
            return false;
        }
        if (other.documentVersion() == null ^ this.documentVersion() == null) {
            return false;
        }
        if (other.documentVersion() != null && !other.documentVersion().equals(this.documentVersion())) {
            return false;
        }
        if (other.automationExecutionStatus() == null ^ this.automationExecutionStatus() == null) {
            return false;
        }
        if (other.automationExecutionStatus() != null && !other.automationExecutionStatus().equals(this.automationExecutionStatus())) {
            return false;
        }
        if (other.executionStartTime() == null ^ this.executionStartTime() == null) {
            return false;
        }
        if (other.executionStartTime() != null && !other.executionStartTime().equals(this.executionStartTime())) {
            return false;
        }
        if (other.executionEndTime() == null ^ this.executionEndTime() == null) {
            return false;
        }
        if (other.executionEndTime() != null && !other.executionEndTime().equals(this.executionEndTime())) {
            return false;
        }
        if (other.executedBy() == null ^ this.executedBy() == null) {
            return false;
        }
        if (other.executedBy() != null && !other.executedBy().equals(this.executedBy())) {
            return false;
        }
        if (other.logFile() == null ^ this.logFile() == null) {
            return false;
        }
        if (other.logFile() != null && !other.logFile().equals(this.logFile())) {
            return false;
        }
        if (other.outputs() == null ^ this.outputs() == null) {
            return false;
        }
        return other.outputs() == null || other.outputs().equals(this.outputs());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.automationExecutionId() != null) {
            sb.append("AutomationExecutionId: ").append(this.automationExecutionId()).append(",");
        }
        if (this.documentName() != null) {
            sb.append("DocumentName: ").append(this.documentName()).append(",");
        }
        if (this.documentVersion() != null) {
            sb.append("DocumentVersion: ").append(this.documentVersion()).append(",");
        }
        if (this.automationExecutionStatus() != null) {
            sb.append("AutomationExecutionStatus: ").append(this.automationExecutionStatus()).append(",");
        }
        if (this.executionStartTime() != null) {
            sb.append("ExecutionStartTime: ").append(this.executionStartTime()).append(",");
        }
        if (this.executionEndTime() != null) {
            sb.append("ExecutionEndTime: ").append(this.executionEndTime()).append(",");
        }
        if (this.executedBy() != null) {
            sb.append("ExecutedBy: ").append(this.executedBy()).append(",");
        }
        if (this.logFile() != null) {
            sb.append("LogFile: ").append(this.logFile()).append(",");
        }
        if (this.outputs() != null) {
            sb.append("Outputs: ").append(this.outputs()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutomationExecutionMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String automationExecutionId;
        private String documentName;
        private String documentVersion;
        private String automationExecutionStatus;
        private Date executionStartTime;
        private Date executionEndTime;
        private String executedBy;
        private String logFile;
        private Map<String, List<String>> outputs;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationExecutionMetadata model) {
            this.setAutomationExecutionId(model.automationExecutionId);
            this.setDocumentName(model.documentName);
            this.setDocumentVersion(model.documentVersion);
            this.setAutomationExecutionStatus(model.automationExecutionStatus);
            this.setExecutionStartTime(model.executionStartTime);
            this.setExecutionEndTime(model.executionEndTime);
            this.setExecutedBy(model.executedBy);
            this.setLogFile(model.logFile);
            this.setOutputs(model.outputs);
        }

        public final String getAutomationExecutionId() {
            return this.automationExecutionId;
        }

        @Override
        public final Builder automationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
            return this;
        }

        public final void setAutomationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
        }

        public final String getDocumentName() {
            return this.documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final String getAutomationExecutionStatus() {
            return this.automationExecutionStatus;
        }

        @Override
        public final Builder automationExecutionStatus(String automationExecutionStatus) {
            this.automationExecutionStatus = automationExecutionStatus;
            return this;
        }

        @Override
        public final Builder automationExecutionStatus(AutomationExecutionStatus automationExecutionStatus) {
            this.automationExecutionStatus(automationExecutionStatus.toString());
            return this;
        }

        public final void setAutomationExecutionStatus(String automationExecutionStatus) {
            this.automationExecutionStatus = automationExecutionStatus;
        }

        public final void setAutomationExecutionStatus(AutomationExecutionStatus automationExecutionStatus) {
            this.automationExecutionStatus(automationExecutionStatus.toString());
        }

        public final Date getExecutionStartTime() {
            return this.executionStartTime;
        }

        @Override
        public final Builder executionStartTime(Date executionStartTime) {
            this.executionStartTime = StandardMemberCopier.copy((Date)executionStartTime);
            return this;
        }

        public final void setExecutionStartTime(Date executionStartTime) {
            this.executionStartTime = StandardMemberCopier.copy((Date)executionStartTime);
        }

        public final Date getExecutionEndTime() {
            return this.executionEndTime;
        }

        @Override
        public final Builder executionEndTime(Date executionEndTime) {
            this.executionEndTime = StandardMemberCopier.copy((Date)executionEndTime);
            return this;
        }

        public final void setExecutionEndTime(Date executionEndTime) {
            this.executionEndTime = StandardMemberCopier.copy((Date)executionEndTime);
        }

        public final String getExecutedBy() {
            return this.executedBy;
        }

        @Override
        public final Builder executedBy(String executedBy) {
            this.executedBy = executedBy;
            return this;
        }

        public final void setExecutedBy(String executedBy) {
            this.executedBy = executedBy;
        }

        public final String getLogFile() {
            return this.logFile;
        }

        @Override
        public final Builder logFile(String logFile) {
            this.logFile = logFile;
            return this;
        }

        public final void setLogFile(String logFile) {
            this.logFile = logFile;
        }

        public final Map<String, ? extends Collection<String>> getOutputs() {
            return this.outputs;
        }

        @Override
        public final Builder outputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
            return this;
        }

        public final void setOutputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
        }

        public AutomationExecutionMetadata build() {
            return new AutomationExecutionMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AutomationExecutionMetadata> {
        public Builder automationExecutionId(String var1);

        public Builder documentName(String var1);

        public Builder documentVersion(String var1);

        public Builder automationExecutionStatus(String var1);

        public Builder automationExecutionStatus(AutomationExecutionStatus var1);

        public Builder executionStartTime(Date var1);

        public Builder executionEndTime(Date var1);

        public Builder executedBy(String var1);

        public Builder logFile(String var1);

        public Builder outputs(Map<String, ? extends Collection<String>> var1);
    }
}

