/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.util.Map;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.ssm.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * GetMaintenanceWindowExecutionTaskResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetMaintenanceWindowExecutionTaskResponseUnmarshaller implements
        Unmarshaller<GetMaintenanceWindowExecutionTaskResponse, JsonUnmarshallerContext> {

    public GetMaintenanceWindowExecutionTaskResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        GetMaintenanceWindowExecutionTaskResponse.Builder getMaintenanceWindowExecutionTaskResponseBuilder = GetMaintenanceWindowExecutionTaskResponse
                .builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return getMaintenanceWindowExecutionTaskResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("WindowExecutionId", targetDepth)) {
                    context.nextToken();
                    getMaintenanceWindowExecutionTaskResponseBuilder.windowExecutionId(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("TaskExecutionId", targetDepth)) {
                    context.nextToken();
                    getMaintenanceWindowExecutionTaskResponseBuilder.taskExecutionId(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("TaskArn", targetDepth)) {
                    context.nextToken();
                    getMaintenanceWindowExecutionTaskResponseBuilder.taskArn(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("ServiceRole", targetDepth)) {
                    context.nextToken();
                    getMaintenanceWindowExecutionTaskResponseBuilder.serviceRole(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("Type", targetDepth)) {
                    context.nextToken();
                    getMaintenanceWindowExecutionTaskResponseBuilder.type(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("TaskParameters", targetDepth)) {
                    context.nextToken();
                    getMaintenanceWindowExecutionTaskResponseBuilder
                            .taskParameters(new ListUnmarshaller<java.util.Map<String, MaintenanceWindowTaskParameterValueExpression>>(
                                    new MapUnmarshaller<String, MaintenanceWindowTaskParameterValueExpression>(context
                                            .getUnmarshaller(String.class),
                                            MaintenanceWindowTaskParameterValueExpressionUnmarshaller.getInstance()))
                                    .unmarshall(context));
                }
                if (context.testExpression("Priority", targetDepth)) {
                    context.nextToken();
                    getMaintenanceWindowExecutionTaskResponseBuilder.priority(context.getUnmarshaller(Integer.class).unmarshall(
                            context));
                }
                if (context.testExpression("MaxConcurrency", targetDepth)) {
                    context.nextToken();
                    getMaintenanceWindowExecutionTaskResponseBuilder.maxConcurrency(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("MaxErrors", targetDepth)) {
                    context.nextToken();
                    getMaintenanceWindowExecutionTaskResponseBuilder.maxErrors(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    getMaintenanceWindowExecutionTaskResponseBuilder.status(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("StatusDetails", targetDepth)) {
                    context.nextToken();
                    getMaintenanceWindowExecutionTaskResponseBuilder.statusDetails(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("StartTime", targetDepth)) {
                    context.nextToken();
                    getMaintenanceWindowExecutionTaskResponseBuilder.startTime(context.getUnmarshaller(java.util.Date.class)
                            .unmarshall(context));
                }
                if (context.testExpression("EndTime", targetDepth)) {
                    context.nextToken();
                    getMaintenanceWindowExecutionTaskResponseBuilder.endTime(context.getUnmarshaller(java.util.Date.class)
                            .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return getMaintenanceWindowExecutionTaskResponseBuilder.build();
    }

    private static GetMaintenanceWindowExecutionTaskResponseUnmarshaller INSTANCE;

    public static GetMaintenanceWindowExecutionTaskResponseUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new GetMaintenanceWindowExecutionTaskResponseUnmarshaller();
        return INSTANCE;
    }
}