/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.ssm.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * DocumentDescription JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DocumentDescriptionUnmarshaller implements Unmarshaller<DocumentDescription, JsonUnmarshallerContext> {

    public DocumentDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        DocumentDescription.Builder documentDescriptionBuilder = DocumentDescription.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("Sha1", targetDepth)) {
                    context.nextToken();
                    documentDescriptionBuilder.sha1(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Hash", targetDepth)) {
                    context.nextToken();
                    documentDescriptionBuilder.hash(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("HashType", targetDepth)) {
                    context.nextToken();
                    documentDescriptionBuilder.hashType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    documentDescriptionBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Owner", targetDepth)) {
                    context.nextToken();
                    documentDescriptionBuilder.owner(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreatedDate", targetDepth)) {
                    context.nextToken();
                    documentDescriptionBuilder.createdDate(context.getUnmarshaller(java.util.Date.class).unmarshall(context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    documentDescriptionBuilder.status(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DocumentVersion", targetDepth)) {
                    context.nextToken();
                    documentDescriptionBuilder.documentVersion(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    documentDescriptionBuilder.description(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Parameters", targetDepth)) {
                    context.nextToken();
                    documentDescriptionBuilder.parameters(new ListUnmarshaller<DocumentParameter>(DocumentParameterUnmarshaller
                            .getInstance()).unmarshall(context));
                }
                if (context.testExpression("PlatformTypes", targetDepth)) {
                    context.nextToken();
                    documentDescriptionBuilder.platformTypes(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))
                            .unmarshall(context));
                }
                if (context.testExpression("DocumentType", targetDepth)) {
                    context.nextToken();
                    documentDescriptionBuilder.documentType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("SchemaVersion", targetDepth)) {
                    context.nextToken();
                    documentDescriptionBuilder.schemaVersion(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("LatestVersion", targetDepth)) {
                    context.nextToken();
                    documentDescriptionBuilder.latestVersion(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DefaultVersion", targetDepth)) {
                    context.nextToken();
                    documentDescriptionBuilder.defaultVersion(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return documentDescriptionBuilder.build();
    }

    private static DocumentDescriptionUnmarshaller INSTANCE;

    public static DocumentDescriptionUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new DocumentDescriptionUnmarshaller();
        return INSTANCE;
    }
}