/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;

import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.ssm.model.*;
import software.amazon.awssdk.services.ssm.transform.*;
import software.amazon.awssdk.runtime.transform.Marshaller;

import software.amazon.awssdk.protocol.*;
import software.amazon.awssdk.annotation.SdkInternalApi;

/**
 * DescribeDocumentPermissionRequest Marshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class DescribeDocumentPermissionRequestMarshaller implements
        Marshaller<Request<DescribeDocumentPermissionRequest>, DescribeDocumentPermissionRequest> {

    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().protocol(Protocol.AWS_JSON)
            .requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true)
            .operationIdentifier("AmazonSSM.DescribeDocumentPermission").serviceName("SSMClient").build();

    private final software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory protocolFactory;

    public DescribeDocumentPermissionRequestMarshaller(software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeDocumentPermissionRequest> marshall(DescribeDocumentPermissionRequest describeDocumentPermissionRequest) {

        if (describeDocumentPermissionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            final ProtocolRequestMarshaller<DescribeDocumentPermissionRequest> protocolMarshaller = protocolFactory
                    .createProtocolMarshaller(SDK_OPERATION_BINDING, describeDocumentPermissionRequest);

            protocolMarshaller.startMarshalling();
            DescribeDocumentPermissionRequestModelMarshaller.getInstance().marshall(describeDocumentPermissionRequest,
                    protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
