/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateDocumentDefaultVersionRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateDocumentDefaultVersionRequest.Builder, UpdateDocumentDefaultVersionRequest> {
    private final String name;

    private final String documentVersion;

    private UpdateDocumentDefaultVersionRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.documentVersion = builder.documentVersion;
    }

    /**
     * <p>
     * The name of a custom document that you want to set as the default version.
     * </p>
     * 
     * @return The name of a custom document that you want to set as the default version.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The version of a custom document that you want to set as the default version.
     * </p>
     * 
     * @return The version of a custom document that you want to set as the default version.
     */
    public String documentVersion() {
        return documentVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((documentVersion() == null) ? 0 : documentVersion().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDocumentDefaultVersionRequest)) {
            return false;
        }
        UpdateDocumentDefaultVersionRequest other = (UpdateDocumentDefaultVersionRequest) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.documentVersion() == null ^ this.documentVersion() == null) {
            return false;
        }
        if (other.documentVersion() != null && !other.documentVersion().equals(this.documentVersion())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (documentVersion() != null) {
            sb.append("DocumentVersion: ").append(documentVersion()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateDocumentDefaultVersionRequest> {
        /**
         * <p>
         * The name of a custom document that you want to set as the default version.
         * </p>
         * 
         * @param name
         *        The name of a custom document that you want to set as the default version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The version of a custom document that you want to set as the default version.
         * </p>
         * 
         * @param documentVersion
         *        The version of a custom document that you want to set as the default version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersion(String documentVersion);
    }

    private static final class BuilderImpl implements Builder {
        private String name;

        private String documentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDocumentDefaultVersionRequest model) {
            setName(model.name);
            setDocumentVersion(model.documentVersion);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDocumentVersion() {
            return documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        @Override
        public UpdateDocumentDefaultVersionRequest build() {
            return new UpdateDocumentDefaultVersionRequest(this);
        }
    }
}
