/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.ssm.transform.StepExecutionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about an the execution state of an Automation step.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StepExecution implements StructuredPojo, ToCopyableBuilder<StepExecution.Builder, StepExecution> {
    private final String stepName;

    private final String action;

    private final Date executionStartTime;

    private final Date executionEndTime;

    private final String stepStatus;

    private final String responseCode;

    private final Map<String, String> inputs;

    private final Map<String, List<String>> outputs;

    private final String response;

    private final String failureMessage;

    private final FailureDetails failureDetails;

    private StepExecution(BuilderImpl builder) {
        this.stepName = builder.stepName;
        this.action = builder.action;
        this.executionStartTime = builder.executionStartTime;
        this.executionEndTime = builder.executionEndTime;
        this.stepStatus = builder.stepStatus;
        this.responseCode = builder.responseCode;
        this.inputs = builder.inputs;
        this.outputs = builder.outputs;
        this.response = builder.response;
        this.failureMessage = builder.failureMessage;
        this.failureDetails = builder.failureDetails;
    }

    /**
     * <p>
     * The name of this execution step.
     * </p>
     * 
     * @return The name of this execution step.
     */
    public String stepName() {
        return stepName;
    }

    /**
     * <p>
     * The action this step performs. The action determines the behavior of the step.
     * </p>
     * 
     * @return The action this step performs. The action determines the behavior of the step.
     */
    public String action() {
        return action;
    }

    /**
     * <p>
     * If a step has begun execution, this contains the time the step started. If the step is in Pending status, this
     * field is not populated.
     * </p>
     * 
     * @return If a step has begun execution, this contains the time the step started. If the step is in Pending status,
     *         this field is not populated.
     */
    public Date executionStartTime() {
        return executionStartTime;
    }

    /**
     * <p>
     * If a step has finished execution, this contains the time the execution ended. If the step has not yet concluded,
     * this field is not populated.
     * </p>
     * 
     * @return If a step has finished execution, this contains the time the execution ended. If the step has not yet
     *         concluded, this field is not populated.
     */
    public Date executionEndTime() {
        return executionEndTime;
    }

    /**
     * <p>
     * The execution status for this step. Valid values include: Pending, InProgress, Success, Cancelled, Failed, and
     * TimedOut.
     * </p>
     * 
     * @return The execution status for this step. Valid values include: Pending, InProgress, Success, Cancelled,
     *         Failed, and TimedOut.
     * @see AutomationExecutionStatus
     */
    public String stepStatus() {
        return stepStatus;
    }

    /**
     * <p>
     * The response code returned by the execution of the step.
     * </p>
     * 
     * @return The response code returned by the execution of the step.
     */
    public String responseCode() {
        return responseCode;
    }

    /**
     * <p>
     * Fully-resolved values passed into the step before execution.
     * </p>
     * 
     * @return Fully-resolved values passed into the step before execution.
     */
    public Map<String, String> inputs() {
        return inputs;
    }

    /**
     * <p>
     * Returned values from the execution of the step.
     * </p>
     * 
     * @return Returned values from the execution of the step.
     */
    public Map<String, List<String>> outputs() {
        return outputs;
    }

    /**
     * <p>
     * A message associated with the response code for an execution.
     * </p>
     * 
     * @return A message associated with the response code for an execution.
     */
    public String response() {
        return response;
    }

    /**
     * <p>
     * If a step failed, this message explains why the execution failed.
     * </p>
     * 
     * @return If a step failed, this message explains why the execution failed.
     */
    public String failureMessage() {
        return failureMessage;
    }

    /**
     * <p>
     * Information about the Automation failure.
     * </p>
     * 
     * @return Information about the Automation failure.
     */
    public FailureDetails failureDetails() {
        return failureDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stepName() == null) ? 0 : stepName().hashCode());
        hashCode = 31 * hashCode + ((action() == null) ? 0 : action().hashCode());
        hashCode = 31 * hashCode + ((executionStartTime() == null) ? 0 : executionStartTime().hashCode());
        hashCode = 31 * hashCode + ((executionEndTime() == null) ? 0 : executionEndTime().hashCode());
        hashCode = 31 * hashCode + ((stepStatus() == null) ? 0 : stepStatus().hashCode());
        hashCode = 31 * hashCode + ((responseCode() == null) ? 0 : responseCode().hashCode());
        hashCode = 31 * hashCode + ((inputs() == null) ? 0 : inputs().hashCode());
        hashCode = 31 * hashCode + ((outputs() == null) ? 0 : outputs().hashCode());
        hashCode = 31 * hashCode + ((response() == null) ? 0 : response().hashCode());
        hashCode = 31 * hashCode + ((failureMessage() == null) ? 0 : failureMessage().hashCode());
        hashCode = 31 * hashCode + ((failureDetails() == null) ? 0 : failureDetails().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepExecution)) {
            return false;
        }
        StepExecution other = (StepExecution) obj;
        if (other.stepName() == null ^ this.stepName() == null) {
            return false;
        }
        if (other.stepName() != null && !other.stepName().equals(this.stepName())) {
            return false;
        }
        if (other.action() == null ^ this.action() == null) {
            return false;
        }
        if (other.action() != null && !other.action().equals(this.action())) {
            return false;
        }
        if (other.executionStartTime() == null ^ this.executionStartTime() == null) {
            return false;
        }
        if (other.executionStartTime() != null && !other.executionStartTime().equals(this.executionStartTime())) {
            return false;
        }
        if (other.executionEndTime() == null ^ this.executionEndTime() == null) {
            return false;
        }
        if (other.executionEndTime() != null && !other.executionEndTime().equals(this.executionEndTime())) {
            return false;
        }
        if (other.stepStatus() == null ^ this.stepStatus() == null) {
            return false;
        }
        if (other.stepStatus() != null && !other.stepStatus().equals(this.stepStatus())) {
            return false;
        }
        if (other.responseCode() == null ^ this.responseCode() == null) {
            return false;
        }
        if (other.responseCode() != null && !other.responseCode().equals(this.responseCode())) {
            return false;
        }
        if (other.inputs() == null ^ this.inputs() == null) {
            return false;
        }
        if (other.inputs() != null && !other.inputs().equals(this.inputs())) {
            return false;
        }
        if (other.outputs() == null ^ this.outputs() == null) {
            return false;
        }
        if (other.outputs() != null && !other.outputs().equals(this.outputs())) {
            return false;
        }
        if (other.response() == null ^ this.response() == null) {
            return false;
        }
        if (other.response() != null && !other.response().equals(this.response())) {
            return false;
        }
        if (other.failureMessage() == null ^ this.failureMessage() == null) {
            return false;
        }
        if (other.failureMessage() != null && !other.failureMessage().equals(this.failureMessage())) {
            return false;
        }
        if (other.failureDetails() == null ^ this.failureDetails() == null) {
            return false;
        }
        if (other.failureDetails() != null && !other.failureDetails().equals(this.failureDetails())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (stepName() != null) {
            sb.append("StepName: ").append(stepName()).append(",");
        }
        if (action() != null) {
            sb.append("Action: ").append(action()).append(",");
        }
        if (executionStartTime() != null) {
            sb.append("ExecutionStartTime: ").append(executionStartTime()).append(",");
        }
        if (executionEndTime() != null) {
            sb.append("ExecutionEndTime: ").append(executionEndTime()).append(",");
        }
        if (stepStatus() != null) {
            sb.append("StepStatus: ").append(stepStatus()).append(",");
        }
        if (responseCode() != null) {
            sb.append("ResponseCode: ").append(responseCode()).append(",");
        }
        if (inputs() != null) {
            sb.append("Inputs: ").append(inputs()).append(",");
        }
        if (outputs() != null) {
            sb.append("Outputs: ").append(outputs()).append(",");
        }
        if (response() != null) {
            sb.append("Response: ").append(response()).append(",");
        }
        if (failureMessage() != null) {
            sb.append("FailureMessage: ").append(failureMessage()).append(",");
        }
        if (failureDetails() != null) {
            sb.append("FailureDetails: ").append(failureDetails()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StepExecutionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, StepExecution> {
        /**
         * <p>
         * The name of this execution step.
         * </p>
         * 
         * @param stepName
         *        The name of this execution step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepName(String stepName);

        /**
         * <p>
         * The action this step performs. The action determines the behavior of the step.
         * </p>
         * 
         * @param action
         *        The action this step performs. The action determines the behavior of the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String action);

        /**
         * <p>
         * If a step has begun execution, this contains the time the step started. If the step is in Pending status,
         * this field is not populated.
         * </p>
         * 
         * @param executionStartTime
         *        If a step has begun execution, this contains the time the step started. If the step is in Pending
         *        status, this field is not populated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStartTime(Date executionStartTime);

        /**
         * <p>
         * If a step has finished execution, this contains the time the execution ended. If the step has not yet
         * concluded, this field is not populated.
         * </p>
         * 
         * @param executionEndTime
         *        If a step has finished execution, this contains the time the execution ended. If the step has not yet
         *        concluded, this field is not populated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionEndTime(Date executionEndTime);

        /**
         * <p>
         * The execution status for this step. Valid values include: Pending, InProgress, Success, Cancelled, Failed,
         * and TimedOut.
         * </p>
         * 
         * @param stepStatus
         *        The execution status for this step. Valid values include: Pending, InProgress, Success, Cancelled,
         *        Failed, and TimedOut.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomationExecutionStatus
         */
        Builder stepStatus(String stepStatus);

        /**
         * <p>
         * The execution status for this step. Valid values include: Pending, InProgress, Success, Cancelled, Failed,
         * and TimedOut.
         * </p>
         * 
         * @param stepStatus
         *        The execution status for this step. Valid values include: Pending, InProgress, Success, Cancelled,
         *        Failed, and TimedOut.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomationExecutionStatus
         */
        Builder stepStatus(AutomationExecutionStatus stepStatus);

        /**
         * <p>
         * The response code returned by the execution of the step.
         * </p>
         * 
         * @param responseCode
         *        The response code returned by the execution of the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseCode(String responseCode);

        /**
         * <p>
         * Fully-resolved values passed into the step before execution.
         * </p>
         * 
         * @param inputs
         *        Fully-resolved values passed into the step before execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Map<String, String> inputs);

        /**
         * <p>
         * Returned values from the execution of the step.
         * </p>
         * 
         * @param outputs
         *        Returned values from the execution of the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Map<String, ? extends Collection<String>> outputs);

        /**
         * <p>
         * A message associated with the response code for an execution.
         * </p>
         * 
         * @param response
         *        A message associated with the response code for an execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder response(String response);

        /**
         * <p>
         * If a step failed, this message explains why the execution failed.
         * </p>
         * 
         * @param failureMessage
         *        If a step failed, this message explains why the execution failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);

        /**
         * <p>
         * Information about the Automation failure.
         * </p>
         * 
         * @param failureDetails
         *        Information about the Automation failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureDetails(FailureDetails failureDetails);
    }

    private static final class BuilderImpl implements Builder {
        private String stepName;

        private String action;

        private Date executionStartTime;

        private Date executionEndTime;

        private String stepStatus;

        private String responseCode;

        private Map<String, String> inputs;

        private Map<String, List<String>> outputs;

        private String response;

        private String failureMessage;

        private FailureDetails failureDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(StepExecution model) {
            setStepName(model.stepName);
            setAction(model.action);
            setExecutionStartTime(model.executionStartTime);
            setExecutionEndTime(model.executionEndTime);
            setStepStatus(model.stepStatus);
            setResponseCode(model.responseCode);
            setInputs(model.inputs);
            setOutputs(model.outputs);
            setResponse(model.response);
            setFailureMessage(model.failureMessage);
            setFailureDetails(model.failureDetails);
        }

        public final String getStepName() {
            return stepName;
        }

        @Override
        public final Builder stepName(String stepName) {
            this.stepName = stepName;
            return this;
        }

        public final void setStepName(String stepName) {
            this.stepName = stepName;
        }

        public final String getAction() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final Date getExecutionStartTime() {
            return executionStartTime;
        }

        @Override
        public final Builder executionStartTime(Date executionStartTime) {
            this.executionStartTime = StandardMemberCopier.copy(executionStartTime);
            return this;
        }

        public final void setExecutionStartTime(Date executionStartTime) {
            this.executionStartTime = StandardMemberCopier.copy(executionStartTime);
        }

        public final Date getExecutionEndTime() {
            return executionEndTime;
        }

        @Override
        public final Builder executionEndTime(Date executionEndTime) {
            this.executionEndTime = StandardMemberCopier.copy(executionEndTime);
            return this;
        }

        public final void setExecutionEndTime(Date executionEndTime) {
            this.executionEndTime = StandardMemberCopier.copy(executionEndTime);
        }

        public final String getStepStatus() {
            return stepStatus;
        }

        @Override
        public final Builder stepStatus(String stepStatus) {
            this.stepStatus = stepStatus;
            return this;
        }

        @Override
        public final Builder stepStatus(AutomationExecutionStatus stepStatus) {
            this.stepStatus(stepStatus.toString());
            return this;
        }

        public final void setStepStatus(String stepStatus) {
            this.stepStatus = stepStatus;
        }

        public final void setStepStatus(AutomationExecutionStatus stepStatus) {
            this.stepStatus(stepStatus.toString());
        }

        public final String getResponseCode() {
            return responseCode;
        }

        @Override
        public final Builder responseCode(String responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        public final void setResponseCode(String responseCode) {
            this.responseCode = responseCode;
        }

        public final Map<String, String> getInputs() {
            return inputs;
        }

        @Override
        public final Builder inputs(Map<String, String> inputs) {
            this.inputs = NormalStringMapCopier.copy(inputs);
            return this;
        }

        public final void setInputs(Map<String, String> inputs) {
            this.inputs = NormalStringMapCopier.copy(inputs);
        }

        public final Map<String, ? extends Collection<String>> getOutputs() {
            return outputs;
        }

        @Override
        public final Builder outputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
            return this;
        }

        public final void setOutputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
        }

        public final String getResponse() {
            return response;
        }

        @Override
        public final Builder response(String response) {
            this.response = response;
            return this;
        }

        public final void setResponse(String response) {
            this.response = response;
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        public final FailureDetails getFailureDetails() {
            return failureDetails;
        }

        @Override
        public final Builder failureDetails(FailureDetails failureDetails) {
            this.failureDetails = failureDetails;
            return this;
        }

        public final void setFailureDetails(FailureDetails failureDetails) {
            this.failureDetails = failureDetails;
        }

        @Override
        public StepExecution build() {
            return new StepExecution(this);
        }
    }
}
