/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.S3OutputLocationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An Amazon S3 bucket where you want to store the results of this request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class S3OutputLocation implements StructuredPojo, ToCopyableBuilder<S3OutputLocation.Builder, S3OutputLocation> {
    private final String outputS3Region;

    private final String outputS3BucketName;

    private final String outputS3KeyPrefix;

    private S3OutputLocation(BuilderImpl builder) {
        this.outputS3Region = builder.outputS3Region;
        this.outputS3BucketName = builder.outputS3BucketName;
        this.outputS3KeyPrefix = builder.outputS3KeyPrefix;
    }

    /**
     * <p>
     * (Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager
     * automatically determines the Amazon S3 bucket region.
     * </p>
     * 
     * @return (Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager
     *         automatically determines the Amazon S3 bucket region.
     */
    public String outputS3Region() {
        return outputS3Region;
    }

    /**
     * <p>
     * The name of the Amazon S3 bucket.
     * </p>
     * 
     * @return The name of the Amazon S3 bucket.
     */
    public String outputS3BucketName() {
        return outputS3BucketName;
    }

    /**
     * <p>
     * The Amazon S3 bucket subfolder.
     * </p>
     * 
     * @return The Amazon S3 bucket subfolder.
     */
    public String outputS3KeyPrefix() {
        return outputS3KeyPrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((outputS3Region() == null) ? 0 : outputS3Region().hashCode());
        hashCode = 31 * hashCode + ((outputS3BucketName() == null) ? 0 : outputS3BucketName().hashCode());
        hashCode = 31 * hashCode + ((outputS3KeyPrefix() == null) ? 0 : outputS3KeyPrefix().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3OutputLocation)) {
            return false;
        }
        S3OutputLocation other = (S3OutputLocation) obj;
        if (other.outputS3Region() == null ^ this.outputS3Region() == null) {
            return false;
        }
        if (other.outputS3Region() != null && !other.outputS3Region().equals(this.outputS3Region())) {
            return false;
        }
        if (other.outputS3BucketName() == null ^ this.outputS3BucketName() == null) {
            return false;
        }
        if (other.outputS3BucketName() != null && !other.outputS3BucketName().equals(this.outputS3BucketName())) {
            return false;
        }
        if (other.outputS3KeyPrefix() == null ^ this.outputS3KeyPrefix() == null) {
            return false;
        }
        if (other.outputS3KeyPrefix() != null && !other.outputS3KeyPrefix().equals(this.outputS3KeyPrefix())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (outputS3Region() != null) {
            sb.append("OutputS3Region: ").append(outputS3Region()).append(",");
        }
        if (outputS3BucketName() != null) {
            sb.append("OutputS3BucketName: ").append(outputS3BucketName()).append(",");
        }
        if (outputS3KeyPrefix() != null) {
            sb.append("OutputS3KeyPrefix: ").append(outputS3KeyPrefix()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3OutputLocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, S3OutputLocation> {
        /**
         * <p>
         * (Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager
         * automatically determines the Amazon S3 bucket region.
         * </p>
         * 
         * @param outputS3Region
         *        (Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager
         *        automatically determines the Amazon S3 bucket region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3Region(String outputS3Region);

        /**
         * <p>
         * The name of the Amazon S3 bucket.
         * </p>
         * 
         * @param outputS3BucketName
         *        The name of the Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3BucketName(String outputS3BucketName);

        /**
         * <p>
         * The Amazon S3 bucket subfolder.
         * </p>
         * 
         * @param outputS3KeyPrefix
         *        The Amazon S3 bucket subfolder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3KeyPrefix(String outputS3KeyPrefix);
    }

    private static final class BuilderImpl implements Builder {
        private String outputS3Region;

        private String outputS3BucketName;

        private String outputS3KeyPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(S3OutputLocation model) {
            setOutputS3Region(model.outputS3Region);
            setOutputS3BucketName(model.outputS3BucketName);
            setOutputS3KeyPrefix(model.outputS3KeyPrefix);
        }

        public final String getOutputS3Region() {
            return outputS3Region;
        }

        @Override
        public final Builder outputS3Region(String outputS3Region) {
            this.outputS3Region = outputS3Region;
            return this;
        }

        public final void setOutputS3Region(String outputS3Region) {
            this.outputS3Region = outputS3Region;
        }

        public final String getOutputS3BucketName() {
            return outputS3BucketName;
        }

        @Override
        public final Builder outputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
            return this;
        }

        public final void setOutputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
        }

        public final String getOutputS3KeyPrefix() {
            return outputS3KeyPrefix;
        }

        @Override
        public final Builder outputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
            return this;
        }

        public final void setOutputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
        }

        @Override
        public S3OutputLocation build() {
            return new S3OutputLocation(this);
        }
    }
}
