/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class RegisterTargetWithMaintenanceWindowRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<RegisterTargetWithMaintenanceWindowRequest.Builder, RegisterTargetWithMaintenanceWindowRequest> {
    private final String windowId;

    private final String resourceType;

    private final List<Target> targets;

    private final String ownerInformation;

    private final String clientToken;

    private RegisterTargetWithMaintenanceWindowRequest(BuilderImpl builder) {
        this.windowId = builder.windowId;
        this.resourceType = builder.resourceType;
        this.targets = builder.targets;
        this.ownerInformation = builder.ownerInformation;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of the Maintenance Window the target should be registered with.
     * </p>
     * 
     * @return The ID of the Maintenance Window the target should be registered with.
     */
    public String windowId() {
        return windowId;
    }

    /**
     * <p>
     * The type of target being registered with the Maintenance Window.
     * </p>
     * 
     * @return The type of target being registered with the Maintenance Window.
     * @see MaintenanceWindowResourceType
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The targets (either instances or tags). Instances are specified using
     * Key=instanceids,Values=&lt;instanceid1&gt;,&lt;instanceid2&gt;. Tags are specified using Key=&lt;tag
     * name&gt;,Values=&lt;tag value&gt;.
     * </p>
     * 
     * @return The targets (either instances or tags). Instances are specified using
     *         Key=instanceids,Values=&lt;instanceid1&gt;,&lt;instanceid2&gt;. Tags are specified using Key=&lt;tag
     *         name&gt;,Values=&lt;tag value&gt;.
     */
    public List<Target> targets() {
        return targets;
    }

    /**
     * <p>
     * User-provided value that will be included in any CloudWatch events raised while running tasks for these targets
     * in this Maintenance Window.
     * </p>
     * 
     * @return User-provided value that will be included in any CloudWatch events raised while running tasks for these
     *         targets in this Maintenance Window.
     */
    public String ownerInformation() {
        return ownerInformation;
    }

    /**
     * <p>
     * User-provided idempotency token.
     * </p>
     * 
     * @return User-provided idempotency token.
     */
    public String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((windowId() == null) ? 0 : windowId().hashCode());
        hashCode = 31 * hashCode + ((resourceType() == null) ? 0 : resourceType().hashCode());
        hashCode = 31 * hashCode + ((targets() == null) ? 0 : targets().hashCode());
        hashCode = 31 * hashCode + ((ownerInformation() == null) ? 0 : ownerInformation().hashCode());
        hashCode = 31 * hashCode + ((clientToken() == null) ? 0 : clientToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterTargetWithMaintenanceWindowRequest)) {
            return false;
        }
        RegisterTargetWithMaintenanceWindowRequest other = (RegisterTargetWithMaintenanceWindowRequest) obj;
        if (other.windowId() == null ^ this.windowId() == null) {
            return false;
        }
        if (other.windowId() != null && !other.windowId().equals(this.windowId())) {
            return false;
        }
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.targets() == null ^ this.targets() == null) {
            return false;
        }
        if (other.targets() != null && !other.targets().equals(this.targets())) {
            return false;
        }
        if (other.ownerInformation() == null ^ this.ownerInformation() == null) {
            return false;
        }
        if (other.ownerInformation() != null && !other.ownerInformation().equals(this.ownerInformation())) {
            return false;
        }
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (windowId() != null) {
            sb.append("WindowId: ").append(windowId()).append(",");
        }
        if (resourceType() != null) {
            sb.append("ResourceType: ").append(resourceType()).append(",");
        }
        if (targets() != null) {
            sb.append("Targets: ").append(targets()).append(",");
        }
        if (ownerInformation() != null) {
            sb.append("OwnerInformation: ").append(ownerInformation()).append(",");
        }
        if (clientToken() != null) {
            sb.append("ClientToken: ").append(clientToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, RegisterTargetWithMaintenanceWindowRequest> {
        /**
         * <p>
         * The ID of the Maintenance Window the target should be registered with.
         * </p>
         * 
         * @param windowId
         *        The ID of the Maintenance Window the target should be registered with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowId(String windowId);

        /**
         * <p>
         * The type of target being registered with the Maintenance Window.
         * </p>
         * 
         * @param resourceType
         *        The type of target being registered with the Maintenance Window.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceWindowResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of target being registered with the Maintenance Window.
         * </p>
         * 
         * @param resourceType
         *        The type of target being registered with the Maintenance Window.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceWindowResourceType
         */
        Builder resourceType(MaintenanceWindowResourceType resourceType);

        /**
         * <p>
         * The targets (either instances or tags). Instances are specified using
         * Key=instanceids,Values=&lt;instanceid1&gt;,&lt;instanceid2&gt;. Tags are specified using Key=&lt;tag
         * name&gt;,Values=&lt;tag value&gt;.
         * </p>
         * 
         * @param targets
         *        The targets (either instances or tags). Instances are specified using
         *        Key=instanceids,Values=&lt;instanceid1&gt;,&lt;instanceid2&gt;. Tags are specified using Key=&lt;tag
         *        name&gt;,Values=&lt;tag value&gt;.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<Target> targets);

        /**
         * <p>
         * The targets (either instances or tags). Instances are specified using
         * Key=instanceids,Values=&lt;instanceid1&gt;,&lt;instanceid2&gt;. Tags are specified using Key=&lt;tag
         * name&gt;,Values=&lt;tag value&gt;.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setTargets(java.util.Collection)} or {@link #withTargets(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param targets
         *        The targets (either instances or tags). Instances are specified using
         *        Key=instanceids,Values=&lt;instanceid1&gt;,&lt;instanceid2&gt;. Tags are specified using Key=&lt;tag
         *        name&gt;,Values=&lt;tag value&gt;.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Target... targets);

        /**
         * <p>
         * User-provided value that will be included in any CloudWatch events raised while running tasks for these
         * targets in this Maintenance Window.
         * </p>
         * 
         * @param ownerInformation
         *        User-provided value that will be included in any CloudWatch events raised while running tasks for
         *        these targets in this Maintenance Window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerInformation(String ownerInformation);

        /**
         * <p>
         * User-provided idempotency token.
         * </p>
         * 
         * @param clientToken
         *        User-provided idempotency token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);
    }

    private static final class BuilderImpl implements Builder {
        private String windowId;

        private String resourceType;

        private List<Target> targets = new SdkInternalList<>();

        private String ownerInformation;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterTargetWithMaintenanceWindowRequest model) {
            setWindowId(model.windowId);
            setResourceType(model.resourceType);
            setTargets(model.targets);
            setOwnerInformation(model.ownerInformation);
            setClientToken(model.clientToken);
        }

        public final String getWindowId() {
            return windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(MaintenanceWindowResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final void setResourceType(MaintenanceWindowResourceType resourceType) {
            this.resourceType(resourceType.toString());
        }

        public final Collection<Target> getTargets() {
            return targets;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target... targets) {
            if (this.targets == null) {
                this.targets = new SdkInternalList<>(targets.length);
            }
            for (Target e : targets) {
                this.targets.add(e);
            }
            return this;
        }

        public final void setTargets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
        }

        @SafeVarargs
        public final void setTargets(Target... targets) {
            if (this.targets == null) {
                this.targets = new SdkInternalList<>(targets.length);
            }
            for (Target e : targets) {
                this.targets.add(e);
            }
        }

        public final String getOwnerInformation() {
            return ownerInformation;
        }

        @Override
        public final Builder ownerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
            return this;
        }

        public final void setOwnerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public RegisterTargetWithMaintenanceWindowRequest build() {
            return new RegisterTargetWithMaintenanceWindowRequest(this);
        }
    }
}
