/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.ssm.transform.ParameterHistoryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about parameter usage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ParameterHistory implements StructuredPojo, ToCopyableBuilder<ParameterHistory.Builder, ParameterHistory> {
    private final String name;

    private final String type;

    private final String keyId;

    private final Date lastModifiedDate;

    private final String lastModifiedUser;

    private final String description;

    private final String value;

    private final String allowedPattern;

    private ParameterHistory(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.keyId = builder.keyId;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.lastModifiedUser = builder.lastModifiedUser;
        this.description = builder.description;
        this.value = builder.value;
        this.allowedPattern = builder.allowedPattern;
    }

    /**
     * <p>
     * The name of the parameter.
     * </p>
     * 
     * @return The name of the parameter.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The type of parameter used.
     * </p>
     * 
     * @return The type of parameter used.
     * @see ParameterType
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * The ID of the query key used for this parameter.
     * </p>
     * 
     * @return The ID of the query key used for this parameter.
     */
    public String keyId() {
        return keyId;
    }

    /**
     * <p>
     * Date the parameter was last changed or updated.
     * </p>
     * 
     * @return Date the parameter was last changed or updated.
     */
    public Date lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the AWS user who last changed the parameter.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the AWS user who last changed the parameter.
     */
    public String lastModifiedUser() {
        return lastModifiedUser;
    }

    /**
     * <p>
     * Information about the parameter.
     * </p>
     * 
     * @return Information about the parameter.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The parameter value.
     * </p>
     * 
     * @return The parameter value.
     */
    public String value() {
        return value;
    }

    /**
     * <p>
     * Parameter names can include the following letters and symbols.
     * </p>
     * <p>
     * a-zA-Z0-9_.-
     * </p>
     * 
     * @return Parameter names can include the following letters and symbols.</p>
     *         <p>
     *         a-zA-Z0-9_.-
     */
    public String allowedPattern() {
        return allowedPattern;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((type() == null) ? 0 : type().hashCode());
        hashCode = 31 * hashCode + ((keyId() == null) ? 0 : keyId().hashCode());
        hashCode = 31 * hashCode + ((lastModifiedDate() == null) ? 0 : lastModifiedDate().hashCode());
        hashCode = 31 * hashCode + ((lastModifiedUser() == null) ? 0 : lastModifiedUser().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((value() == null) ? 0 : value().hashCode());
        hashCode = 31 * hashCode + ((allowedPattern() == null) ? 0 : allowedPattern().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterHistory)) {
            return false;
        }
        ParameterHistory other = (ParameterHistory) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        if (other.keyId() != null && !other.keyId().equals(this.keyId())) {
            return false;
        }
        if (other.lastModifiedDate() == null ^ this.lastModifiedDate() == null) {
            return false;
        }
        if (other.lastModifiedDate() != null && !other.lastModifiedDate().equals(this.lastModifiedDate())) {
            return false;
        }
        if (other.lastModifiedUser() == null ^ this.lastModifiedUser() == null) {
            return false;
        }
        if (other.lastModifiedUser() != null && !other.lastModifiedUser().equals(this.lastModifiedUser())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.value() == null ^ this.value() == null) {
            return false;
        }
        if (other.value() != null && !other.value().equals(this.value())) {
            return false;
        }
        if (other.allowedPattern() == null ^ this.allowedPattern() == null) {
            return false;
        }
        if (other.allowedPattern() != null && !other.allowedPattern().equals(this.allowedPattern())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (type() != null) {
            sb.append("Type: ").append(type()).append(",");
        }
        if (keyId() != null) {
            sb.append("KeyId: ").append(keyId()).append(",");
        }
        if (lastModifiedDate() != null) {
            sb.append("LastModifiedDate: ").append(lastModifiedDate()).append(",");
        }
        if (lastModifiedUser() != null) {
            sb.append("LastModifiedUser: ").append(lastModifiedUser()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (value() != null) {
            sb.append("Value: ").append(value()).append(",");
        }
        if (allowedPattern() != null) {
            sb.append("AllowedPattern: ").append(allowedPattern()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ParameterHistoryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ParameterHistory> {
        /**
         * <p>
         * The name of the parameter.
         * </p>
         * 
         * @param name
         *        The name of the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of parameter used.
         * </p>
         * 
         * @param type
         *        The type of parameter used.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParameterType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of parameter used.
         * </p>
         * 
         * @param type
         *        The type of parameter used.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParameterType
         */
        Builder type(ParameterType type);

        /**
         * <p>
         * The ID of the query key used for this parameter.
         * </p>
         * 
         * @param keyId
         *        The ID of the query key used for this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyId(String keyId);

        /**
         * <p>
         * Date the parameter was last changed or updated.
         * </p>
         * 
         * @param lastModifiedDate
         *        Date the parameter was last changed or updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Date lastModifiedDate);

        /**
         * <p>
         * Amazon Resource Name (ARN) of the AWS user who last changed the parameter.
         * </p>
         * 
         * @param lastModifiedUser
         *        Amazon Resource Name (ARN) of the AWS user who last changed the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedUser(String lastModifiedUser);

        /**
         * <p>
         * Information about the parameter.
         * </p>
         * 
         * @param description
         *        Information about the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The parameter value.
         * </p>
         * 
         * @param value
         *        The parameter value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * Parameter names can include the following letters and symbols.
         * </p>
         * <p>
         * a-zA-Z0-9_.-
         * </p>
         * 
         * @param allowedPattern
         *        Parameter names can include the following letters and symbols.</p>
         *        <p>
         *        a-zA-Z0-9_.-
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedPattern(String allowedPattern);
    }

    private static final class BuilderImpl implements Builder {
        private String name;

        private String type;

        private String keyId;

        private Date lastModifiedDate;

        private String lastModifiedUser;

        private String description;

        private String value;

        private String allowedPattern;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterHistory model) {
            setName(model.name);
            setType(model.type);
            setKeyId(model.keyId);
            setLastModifiedDate(model.lastModifiedDate);
            setLastModifiedUser(model.lastModifiedUser);
            setDescription(model.description);
            setValue(model.value);
            setAllowedPattern(model.allowedPattern);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ParameterType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(ParameterType type) {
            this.type(type.toString());
        }

        public final String getKeyId() {
            return keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final Date getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Date lastModifiedDate) {
            this.lastModifiedDate = StandardMemberCopier.copy(lastModifiedDate);
            return this;
        }

        public final void setLastModifiedDate(Date lastModifiedDate) {
            this.lastModifiedDate = StandardMemberCopier.copy(lastModifiedDate);
        }

        public final String getLastModifiedUser() {
            return lastModifiedUser;
        }

        @Override
        public final Builder lastModifiedUser(String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
            return this;
        }

        public final void setLastModifiedUser(String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getAllowedPattern() {
            return allowedPattern;
        }

        @Override
        public final Builder allowedPattern(String allowedPattern) {
            this.allowedPattern = allowedPattern;
            return this;
        }

        public final void setAllowedPattern(String allowedPattern) {
            this.allowedPattern = allowedPattern;
        }

        @Override
        public ParameterHistory build() {
            return new ParameterHistory(this);
        }
    }
}
