/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ssm.transform.MaintenanceWindowTaskParameterValueExpressionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the values for a task parameter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MaintenanceWindowTaskParameterValueExpression implements StructuredPojo,
        ToCopyableBuilder<MaintenanceWindowTaskParameterValueExpression.Builder, MaintenanceWindowTaskParameterValueExpression> {
    private final List<String> values;

    private MaintenanceWindowTaskParameterValueExpression(BuilderImpl builder) {
        this.values = builder.values;
    }

    /**
     * <p>
     * This field contains an array of 0 or more strings, each 1 to 255 characters in length.
     * </p>
     * 
     * @return This field contains an array of 0 or more strings, each 1 to 255 characters in length.
     */
    public List<String> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((values() == null) ? 0 : values().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowTaskParameterValueExpression)) {
            return false;
        }
        MaintenanceWindowTaskParameterValueExpression other = (MaintenanceWindowTaskParameterValueExpression) obj;
        if (other.values() == null ^ this.values() == null) {
            return false;
        }
        if (other.values() != null && !other.values().equals(this.values())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (values() != null) {
            sb.append("Values: ").append(values()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MaintenanceWindowTaskParameterValueExpressionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, MaintenanceWindowTaskParameterValueExpression> {
        /**
         * <p>
         * This field contains an array of 0 or more strings, each 1 to 255 characters in length.
         * </p>
         * 
         * @param values
         *        This field contains an array of 0 or more strings, each 1 to 255 characters in length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * This field contains an array of 0 or more strings, each 1 to 255 characters in length.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setValues(java.util.Collection)} or {@link #withValues(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param values
         *        This field contains an array of 0 or more strings, each 1 to 255 characters in length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> values = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowTaskParameterValueExpression model) {
            setValues(model.values);
        }

        public final Collection<String> getValues() {
            return values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = MaintenanceWindowTaskParameterValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            if (this.values == null) {
                this.values = new SdkInternalList<>(values.length);
            }
            for (String e : values) {
                this.values.add(e);
            }
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = MaintenanceWindowTaskParameterValueListCopier.copy(values);
        }

        @SafeVarargs
        public final void setValues(String... values) {
            if (this.values == null) {
                this.values = new SdkInternalList<>(values.length);
            }
            for (String e : values) {
                this.values.add(e);
            }
        }

        @Override
        public MaintenanceWindowTaskParameterValueExpression build() {
            return new MaintenanceWindowTaskParameterValueExpression(this);
        }
    }
}
