/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListDocumentVersionsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListDocumentVersionsResponse.Builder, ListDocumentVersionsResponse> {
    private final List<DocumentVersionInfo> documentVersions;

    private final String nextToken;

    private ListDocumentVersionsResponse(BuilderImpl builder) {
        this.documentVersions = builder.documentVersions;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The document versions.
     * </p>
     * 
     * @return The document versions.
     */
    public List<DocumentVersionInfo> documentVersions() {
        return documentVersions;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((documentVersions() == null) ? 0 : documentVersions().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDocumentVersionsResponse)) {
            return false;
        }
        ListDocumentVersionsResponse other = (ListDocumentVersionsResponse) obj;
        if (other.documentVersions() == null ^ this.documentVersions() == null) {
            return false;
        }
        if (other.documentVersions() != null && !other.documentVersions().equals(this.documentVersions())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (documentVersions() != null) {
            sb.append("DocumentVersions: ").append(documentVersions()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListDocumentVersionsResponse> {
        /**
         * <p>
         * The document versions.
         * </p>
         * 
         * @param documentVersions
         *        The document versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersions(Collection<DocumentVersionInfo> documentVersions);

        /**
         * <p>
         * The document versions.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setDocumentVersions(java.util.Collection)} or {@link #withDocumentVersions(java.util.Collection)} if
         * you want to override the existing values.
         * </p>
         * 
         * @param documentVersions
         *        The document versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersions(DocumentVersionInfo... documentVersions);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<DocumentVersionInfo> documentVersions = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDocumentVersionsResponse model) {
            setDocumentVersions(model.documentVersions);
            setNextToken(model.nextToken);
        }

        public final Collection<DocumentVersionInfo> getDocumentVersions() {
            return documentVersions;
        }

        @Override
        public final Builder documentVersions(Collection<DocumentVersionInfo> documentVersions) {
            this.documentVersions = DocumentVersionListCopier.copy(documentVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentVersions(DocumentVersionInfo... documentVersions) {
            if (this.documentVersions == null) {
                this.documentVersions = new SdkInternalList<>(documentVersions.length);
            }
            for (DocumentVersionInfo e : documentVersions) {
                this.documentVersions.add(e);
            }
            return this;
        }

        public final void setDocumentVersions(Collection<DocumentVersionInfo> documentVersions) {
            this.documentVersions = DocumentVersionListCopier.copy(documentVersions);
        }

        @SafeVarargs
        public final void setDocumentVersions(DocumentVersionInfo... documentVersions) {
            if (this.documentVersions == null) {
                this.documentVersions = new SdkInternalList<>(documentVersions.length);
            }
            for (DocumentVersionInfo e : documentVersions) {
                this.documentVersions.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDocumentVersionsResponse build() {
            return new ListDocumentVersionsResponse(this);
        }
    }
}
