/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.ssm.transform.InstancePatchStateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the high-level patch compliance state for a managed instance, providing information about the number of
 * installed, missing, not applicable, and failed patches along with metadata about the operation when this information
 * was gathered for the instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstancePatchState implements StructuredPojo, ToCopyableBuilder<InstancePatchState.Builder, InstancePatchState> {
    private final String instanceId;

    private final String patchGroup;

    private final String baselineId;

    private final String snapshotId;

    private final String ownerInformation;

    private final Integer installedCount;

    private final Integer installedOtherCount;

    private final Integer missingCount;

    private final Integer failedCount;

    private final Integer notApplicableCount;

    private final Date operationStartTime;

    private final Date operationEndTime;

    private final String operation;

    private InstancePatchState(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.patchGroup = builder.patchGroup;
        this.baselineId = builder.baselineId;
        this.snapshotId = builder.snapshotId;
        this.ownerInformation = builder.ownerInformation;
        this.installedCount = builder.installedCount;
        this.installedOtherCount = builder.installedOtherCount;
        this.missingCount = builder.missingCount;
        this.failedCount = builder.failedCount;
        this.notApplicableCount = builder.notApplicableCount;
        this.operationStartTime = builder.operationStartTime;
        this.operationEndTime = builder.operationEndTime;
        this.operation = builder.operation;
    }

    /**
     * <p>
     * The ID of the managed instance the high-level patch compliance information was collected for.
     * </p>
     * 
     * @return The ID of the managed instance the high-level patch compliance information was collected for.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The name of the patch group the managed instance belongs to.
     * </p>
     * 
     * @return The name of the patch group the managed instance belongs to.
     */
    public String patchGroup() {
        return patchGroup;
    }

    /**
     * <p>
     * The ID of the patch baseline used to patch the instance.
     * </p>
     * 
     * @return The ID of the patch baseline used to patch the instance.
     */
    public String baselineId() {
        return baselineId;
    }

    /**
     * <p>
     * The ID of the patch baseline snapshot used during the patching operation when this compliance data was collected.
     * </p>
     * 
     * @return The ID of the patch baseline snapshot used during the patching operation when this compliance data was
     *         collected.
     */
    public String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * Placeholder information, this field will always be empty in the current release of the service.
     * </p>
     * 
     * @return Placeholder information, this field will always be empty in the current release of the service.
     */
    public String ownerInformation() {
        return ownerInformation;
    }

    /**
     * <p>
     * The number of patches from the patch baseline that are installed on the instance.
     * </p>
     * 
     * @return The number of patches from the patch baseline that are installed on the instance.
     */
    public Integer installedCount() {
        return installedCount;
    }

    /**
     * <p>
     * The number of patches not specified in the patch baseline that are installed on the instance.
     * </p>
     * 
     * @return The number of patches not specified in the patch baseline that are installed on the instance.
     */
    public Integer installedOtherCount() {
        return installedOtherCount;
    }

    /**
     * <p>
     * The number of patches from the patch baseline that are applicable for the instance but aren't currently
     * installed.
     * </p>
     * 
     * @return The number of patches from the patch baseline that are applicable for the instance but aren't currently
     *         installed.
     */
    public Integer missingCount() {
        return missingCount;
    }

    /**
     * <p>
     * The number of patches from the patch baseline that were attempted to be installed during the last patching
     * operation, but failed to install.
     * </p>
     * 
     * @return The number of patches from the patch baseline that were attempted to be installed during the last
     *         patching operation, but failed to install.
     */
    public Integer failedCount() {
        return failedCount;
    }

    /**
     * <p>
     * The number of patches from the patch baseline that aren't applicable for the instance and hence aren't installed
     * on the instance.
     * </p>
     * 
     * @return The number of patches from the patch baseline that aren't applicable for the instance and hence aren't
     *         installed on the instance.
     */
    public Integer notApplicableCount() {
        return notApplicableCount;
    }

    /**
     * <p>
     * The time the most recent patching operation was started on the instance.
     * </p>
     * 
     * @return The time the most recent patching operation was started on the instance.
     */
    public Date operationStartTime() {
        return operationStartTime;
    }

    /**
     * <p>
     * The time the most recent patching operation completed on the instance.
     * </p>
     * 
     * @return The time the most recent patching operation completed on the instance.
     */
    public Date operationEndTime() {
        return operationEndTime;
    }

    /**
     * <p>
     * The type of patching operation that was performed: SCAN (assess patch compliance state) or INSTALL (install
     * missing patches).
     * </p>
     * 
     * @return The type of patching operation that was performed: SCAN (assess patch compliance state) or INSTALL
     *         (install missing patches).
     * @see PatchOperationType
     */
    public String operation() {
        return operation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((patchGroup() == null) ? 0 : patchGroup().hashCode());
        hashCode = 31 * hashCode + ((baselineId() == null) ? 0 : baselineId().hashCode());
        hashCode = 31 * hashCode + ((snapshotId() == null) ? 0 : snapshotId().hashCode());
        hashCode = 31 * hashCode + ((ownerInformation() == null) ? 0 : ownerInformation().hashCode());
        hashCode = 31 * hashCode + ((installedCount() == null) ? 0 : installedCount().hashCode());
        hashCode = 31 * hashCode + ((installedOtherCount() == null) ? 0 : installedOtherCount().hashCode());
        hashCode = 31 * hashCode + ((missingCount() == null) ? 0 : missingCount().hashCode());
        hashCode = 31 * hashCode + ((failedCount() == null) ? 0 : failedCount().hashCode());
        hashCode = 31 * hashCode + ((notApplicableCount() == null) ? 0 : notApplicableCount().hashCode());
        hashCode = 31 * hashCode + ((operationStartTime() == null) ? 0 : operationStartTime().hashCode());
        hashCode = 31 * hashCode + ((operationEndTime() == null) ? 0 : operationEndTime().hashCode());
        hashCode = 31 * hashCode + ((operation() == null) ? 0 : operation().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstancePatchState)) {
            return false;
        }
        InstancePatchState other = (InstancePatchState) obj;
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.patchGroup() == null ^ this.patchGroup() == null) {
            return false;
        }
        if (other.patchGroup() != null && !other.patchGroup().equals(this.patchGroup())) {
            return false;
        }
        if (other.baselineId() == null ^ this.baselineId() == null) {
            return false;
        }
        if (other.baselineId() != null && !other.baselineId().equals(this.baselineId())) {
            return false;
        }
        if (other.snapshotId() == null ^ this.snapshotId() == null) {
            return false;
        }
        if (other.snapshotId() != null && !other.snapshotId().equals(this.snapshotId())) {
            return false;
        }
        if (other.ownerInformation() == null ^ this.ownerInformation() == null) {
            return false;
        }
        if (other.ownerInformation() != null && !other.ownerInformation().equals(this.ownerInformation())) {
            return false;
        }
        if (other.installedCount() == null ^ this.installedCount() == null) {
            return false;
        }
        if (other.installedCount() != null && !other.installedCount().equals(this.installedCount())) {
            return false;
        }
        if (other.installedOtherCount() == null ^ this.installedOtherCount() == null) {
            return false;
        }
        if (other.installedOtherCount() != null && !other.installedOtherCount().equals(this.installedOtherCount())) {
            return false;
        }
        if (other.missingCount() == null ^ this.missingCount() == null) {
            return false;
        }
        if (other.missingCount() != null && !other.missingCount().equals(this.missingCount())) {
            return false;
        }
        if (other.failedCount() == null ^ this.failedCount() == null) {
            return false;
        }
        if (other.failedCount() != null && !other.failedCount().equals(this.failedCount())) {
            return false;
        }
        if (other.notApplicableCount() == null ^ this.notApplicableCount() == null) {
            return false;
        }
        if (other.notApplicableCount() != null && !other.notApplicableCount().equals(this.notApplicableCount())) {
            return false;
        }
        if (other.operationStartTime() == null ^ this.operationStartTime() == null) {
            return false;
        }
        if (other.operationStartTime() != null && !other.operationStartTime().equals(this.operationStartTime())) {
            return false;
        }
        if (other.operationEndTime() == null ^ this.operationEndTime() == null) {
            return false;
        }
        if (other.operationEndTime() != null && !other.operationEndTime().equals(this.operationEndTime())) {
            return false;
        }
        if (other.operation() == null ^ this.operation() == null) {
            return false;
        }
        if (other.operation() != null && !other.operation().equals(this.operation())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (patchGroup() != null) {
            sb.append("PatchGroup: ").append(patchGroup()).append(",");
        }
        if (baselineId() != null) {
            sb.append("BaselineId: ").append(baselineId()).append(",");
        }
        if (snapshotId() != null) {
            sb.append("SnapshotId: ").append(snapshotId()).append(",");
        }
        if (ownerInformation() != null) {
            sb.append("OwnerInformation: ").append(ownerInformation()).append(",");
        }
        if (installedCount() != null) {
            sb.append("InstalledCount: ").append(installedCount()).append(",");
        }
        if (installedOtherCount() != null) {
            sb.append("InstalledOtherCount: ").append(installedOtherCount()).append(",");
        }
        if (missingCount() != null) {
            sb.append("MissingCount: ").append(missingCount()).append(",");
        }
        if (failedCount() != null) {
            sb.append("FailedCount: ").append(failedCount()).append(",");
        }
        if (notApplicableCount() != null) {
            sb.append("NotApplicableCount: ").append(notApplicableCount()).append(",");
        }
        if (operationStartTime() != null) {
            sb.append("OperationStartTime: ").append(operationStartTime()).append(",");
        }
        if (operationEndTime() != null) {
            sb.append("OperationEndTime: ").append(operationEndTime()).append(",");
        }
        if (operation() != null) {
            sb.append("Operation: ").append(operation()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstancePatchStateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InstancePatchState> {
        /**
         * <p>
         * The ID of the managed instance the high-level patch compliance information was collected for.
         * </p>
         * 
         * @param instanceId
         *        The ID of the managed instance the high-level patch compliance information was collected for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The name of the patch group the managed instance belongs to.
         * </p>
         * 
         * @param patchGroup
         *        The name of the patch group the managed instance belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchGroup(String patchGroup);

        /**
         * <p>
         * The ID of the patch baseline used to patch the instance.
         * </p>
         * 
         * @param baselineId
         *        The ID of the patch baseline used to patch the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineId(String baselineId);

        /**
         * <p>
         * The ID of the patch baseline snapshot used during the patching operation when this compliance data was
         * collected.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the patch baseline snapshot used during the patching operation when this compliance data was
         *        collected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * Placeholder information, this field will always be empty in the current release of the service.
         * </p>
         * 
         * @param ownerInformation
         *        Placeholder information, this field will always be empty in the current release of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerInformation(String ownerInformation);

        /**
         * <p>
         * The number of patches from the patch baseline that are installed on the instance.
         * </p>
         * 
         * @param installedCount
         *        The number of patches from the patch baseline that are installed on the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder installedCount(Integer installedCount);

        /**
         * <p>
         * The number of patches not specified in the patch baseline that are installed on the instance.
         * </p>
         * 
         * @param installedOtherCount
         *        The number of patches not specified in the patch baseline that are installed on the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder installedOtherCount(Integer installedOtherCount);

        /**
         * <p>
         * The number of patches from the patch baseline that are applicable for the instance but aren't currently
         * installed.
         * </p>
         * 
         * @param missingCount
         *        The number of patches from the patch baseline that are applicable for the instance but aren't
         *        currently installed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missingCount(Integer missingCount);

        /**
         * <p>
         * The number of patches from the patch baseline that were attempted to be installed during the last patching
         * operation, but failed to install.
         * </p>
         * 
         * @param failedCount
         *        The number of patches from the patch baseline that were attempted to be installed during the last
         *        patching operation, but failed to install.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedCount(Integer failedCount);

        /**
         * <p>
         * The number of patches from the patch baseline that aren't applicable for the instance and hence aren't
         * installed on the instance.
         * </p>
         * 
         * @param notApplicableCount
         *        The number of patches from the patch baseline that aren't applicable for the instance and hence aren't
         *        installed on the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notApplicableCount(Integer notApplicableCount);

        /**
         * <p>
         * The time the most recent patching operation was started on the instance.
         * </p>
         * 
         * @param operationStartTime
         *        The time the most recent patching operation was started on the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationStartTime(Date operationStartTime);

        /**
         * <p>
         * The time the most recent patching operation completed on the instance.
         * </p>
         * 
         * @param operationEndTime
         *        The time the most recent patching operation completed on the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationEndTime(Date operationEndTime);

        /**
         * <p>
         * The type of patching operation that was performed: SCAN (assess patch compliance state) or INSTALL (install
         * missing patches).
         * </p>
         * 
         * @param operation
         *        The type of patching operation that was performed: SCAN (assess patch compliance state) or INSTALL
         *        (install missing patches).
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PatchOperationType
         */
        Builder operation(String operation);

        /**
         * <p>
         * The type of patching operation that was performed: SCAN (assess patch compliance state) or INSTALL (install
         * missing patches).
         * </p>
         * 
         * @param operation
         *        The type of patching operation that was performed: SCAN (assess patch compliance state) or INSTALL
         *        (install missing patches).
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PatchOperationType
         */
        Builder operation(PatchOperationType operation);
    }

    private static final class BuilderImpl implements Builder {
        private String instanceId;

        private String patchGroup;

        private String baselineId;

        private String snapshotId;

        private String ownerInformation;

        private Integer installedCount;

        private Integer installedOtherCount;

        private Integer missingCount;

        private Integer failedCount;

        private Integer notApplicableCount;

        private Date operationStartTime;

        private Date operationEndTime;

        private String operation;

        private BuilderImpl() {
        }

        private BuilderImpl(InstancePatchState model) {
            setInstanceId(model.instanceId);
            setPatchGroup(model.patchGroup);
            setBaselineId(model.baselineId);
            setSnapshotId(model.snapshotId);
            setOwnerInformation(model.ownerInformation);
            setInstalledCount(model.installedCount);
            setInstalledOtherCount(model.installedOtherCount);
            setMissingCount(model.missingCount);
            setFailedCount(model.failedCount);
            setNotApplicableCount(model.notApplicableCount);
            setOperationStartTime(model.operationStartTime);
            setOperationEndTime(model.operationEndTime);
            setOperation(model.operation);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getPatchGroup() {
            return patchGroup;
        }

        @Override
        public final Builder patchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
            return this;
        }

        public final void setPatchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
        }

        public final String getBaselineId() {
            return baselineId;
        }

        @Override
        public final Builder baselineId(String baselineId) {
            this.baselineId = baselineId;
            return this;
        }

        public final void setBaselineId(String baselineId) {
            this.baselineId = baselineId;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final String getOwnerInformation() {
            return ownerInformation;
        }

        @Override
        public final Builder ownerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
            return this;
        }

        public final void setOwnerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
        }

        public final Integer getInstalledCount() {
            return installedCount;
        }

        @Override
        public final Builder installedCount(Integer installedCount) {
            this.installedCount = installedCount;
            return this;
        }

        public final void setInstalledCount(Integer installedCount) {
            this.installedCount = installedCount;
        }

        public final Integer getInstalledOtherCount() {
            return installedOtherCount;
        }

        @Override
        public final Builder installedOtherCount(Integer installedOtherCount) {
            this.installedOtherCount = installedOtherCount;
            return this;
        }

        public final void setInstalledOtherCount(Integer installedOtherCount) {
            this.installedOtherCount = installedOtherCount;
        }

        public final Integer getMissingCount() {
            return missingCount;
        }

        @Override
        public final Builder missingCount(Integer missingCount) {
            this.missingCount = missingCount;
            return this;
        }

        public final void setMissingCount(Integer missingCount) {
            this.missingCount = missingCount;
        }

        public final Integer getFailedCount() {
            return failedCount;
        }

        @Override
        public final Builder failedCount(Integer failedCount) {
            this.failedCount = failedCount;
            return this;
        }

        public final void setFailedCount(Integer failedCount) {
            this.failedCount = failedCount;
        }

        public final Integer getNotApplicableCount() {
            return notApplicableCount;
        }

        @Override
        public final Builder notApplicableCount(Integer notApplicableCount) {
            this.notApplicableCount = notApplicableCount;
            return this;
        }

        public final void setNotApplicableCount(Integer notApplicableCount) {
            this.notApplicableCount = notApplicableCount;
        }

        public final Date getOperationStartTime() {
            return operationStartTime;
        }

        @Override
        public final Builder operationStartTime(Date operationStartTime) {
            this.operationStartTime = StandardMemberCopier.copy(operationStartTime);
            return this;
        }

        public final void setOperationStartTime(Date operationStartTime) {
            this.operationStartTime = StandardMemberCopier.copy(operationStartTime);
        }

        public final Date getOperationEndTime() {
            return operationEndTime;
        }

        @Override
        public final Builder operationEndTime(Date operationEndTime) {
            this.operationEndTime = StandardMemberCopier.copy(operationEndTime);
            return this;
        }

        public final void setOperationEndTime(Date operationEndTime) {
            this.operationEndTime = StandardMemberCopier.copy(operationEndTime);
        }

        public final String getOperation() {
            return operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public final Builder operation(PatchOperationType operation) {
            this.operation(operation.toString());
            return this;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        public final void setOperation(PatchOperationType operation) {
            this.operation(operation.toString());
        }

        @Override
        public InstancePatchState build() {
            return new InstancePatchState(this);
        }
    }
}
