/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ssm.transform.InstanceInformationStringFilterMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The filters to describe or get information about your managed instances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceInformationStringFilter implements StructuredPojo,
        ToCopyableBuilder<InstanceInformationStringFilter.Builder, InstanceInformationStringFilter> {
    private final String key;

    private final List<String> values;

    private InstanceInformationStringFilter(BuilderImpl builder) {
        this.key = builder.key;
        this.values = builder.values;
    }

    /**
     * <p>
     * The filter key name to describe your instances. For example:
     * </p>
     * <p>
     * "InstanceIds"|"AgentVersion"|"PingStatus"|"PlatformTypes"|"ActivationIds"|"IamRole"|"ResourceType"|
     * "AssociationStatus"|"Tag Key"
     * </p>
     * 
     * @return The filter key name to describe your instances. For example:</p>
     *         <p>
     *         "InstanceIds"|"AgentVersion"|"PingStatus"|"PlatformTypes"|"ActivationIds"|"IamRole"|"ResourceType"|
     *         "AssociationStatus"|"Tag Key"
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * The filter values.
     * </p>
     * 
     * @return The filter values.
     */
    public List<String> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((key() == null) ? 0 : key().hashCode());
        hashCode = 31 * hashCode + ((values() == null) ? 0 : values().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceInformationStringFilter)) {
            return false;
        }
        InstanceInformationStringFilter other = (InstanceInformationStringFilter) obj;
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.values() == null ^ this.values() == null) {
            return false;
        }
        if (other.values() != null && !other.values().equals(this.values())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (key() != null) {
            sb.append("Key: ").append(key()).append(",");
        }
        if (values() != null) {
            sb.append("Values: ").append(values()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceInformationStringFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceInformationStringFilter> {
        /**
         * <p>
         * The filter key name to describe your instances. For example:
         * </p>
         * <p>
         * "InstanceIds"|"AgentVersion"|"PingStatus"|"PlatformTypes"|"ActivationIds"|"IamRole"|"ResourceType"|
         * "AssociationStatus"|"Tag Key"
         * </p>
         * 
         * @param key
         *        The filter key name to describe your instances. For example:</p>
         *        <p>
         *        "InstanceIds"|"AgentVersion"|"PingStatus"|"PlatformTypes"|"ActivationIds"|"IamRole"|"ResourceType"|
         *        "AssociationStatus"|"Tag Key"
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The filter values.
         * </p>
         * 
         * @param values
         *        The filter values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * The filter values.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setValues(java.util.Collection)} or {@link #withValues(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param values
         *        The filter values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);
    }

    private static final class BuilderImpl implements Builder {
        private String key;

        private List<String> values = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceInformationStringFilter model) {
            setKey(model.key);
            setValues(model.values);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Collection<String> getValues() {
            return values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = InstanceInformationFilterValueSetCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            if (this.values == null) {
                this.values = new SdkInternalList<>(values.length);
            }
            for (String e : values) {
                this.values.add(e);
            }
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = InstanceInformationFilterValueSetCopier.copy(values);
        }

        @SafeVarargs
        public final void setValues(String... values) {
            if (this.values == null) {
                this.values = new SdkInternalList<>(values.length);
            }
            for (String e : values) {
                this.values.add(e);
            }
        }

        @Override
        public InstanceInformationStringFilter build() {
            return new InstanceInformationStringFilter(this);
        }
    }
}
