/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetParametersResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetParametersResponse.Builder, GetParametersResponse> {
    private final List<Parameter> parameters;

    private final List<String> invalidParameters;

    private GetParametersResponse(BuilderImpl builder) {
        this.parameters = builder.parameters;
        this.invalidParameters = builder.invalidParameters;
    }

    /**
     * <p>
     * A list of details for a parameter.
     * </p>
     * 
     * @return A list of details for a parameter.
     */
    public List<Parameter> parameters() {
        return parameters;
    }

    /**
     * <p>
     * A list of parameters that are not formatted correctly or do not run when executed.
     * </p>
     * 
     * @return A list of parameters that are not formatted correctly or do not run when executed.
     */
    public List<String> invalidParameters() {
        return invalidParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((parameters() == null) ? 0 : parameters().hashCode());
        hashCode = 31 * hashCode + ((invalidParameters() == null) ? 0 : invalidParameters().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParametersResponse)) {
            return false;
        }
        GetParametersResponse other = (GetParametersResponse) obj;
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.invalidParameters() == null ^ this.invalidParameters() == null) {
            return false;
        }
        if (other.invalidParameters() != null && !other.invalidParameters().equals(this.invalidParameters())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (parameters() != null) {
            sb.append("Parameters: ").append(parameters()).append(",");
        }
        if (invalidParameters() != null) {
            sb.append("InvalidParameters: ").append(invalidParameters()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetParametersResponse> {
        /**
         * <p>
         * A list of details for a parameter.
         * </p>
         * 
         * @param parameters
         *        A list of details for a parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<Parameter> parameters);

        /**
         * <p>
         * A list of details for a parameter.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setParameters(java.util.Collection)} or {@link #withParameters(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param parameters
         *        A list of details for a parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Parameter... parameters);

        /**
         * <p>
         * A list of parameters that are not formatted correctly or do not run when executed.
         * </p>
         * 
         * @param invalidParameters
         *        A list of parameters that are not formatted correctly or do not run when executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidParameters(Collection<String> invalidParameters);

        /**
         * <p>
         * A list of parameters that are not formatted correctly or do not run when executed.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setInvalidParameters(java.util.Collection)} or {@link #withInvalidParameters(java.util.Collection)}
         * if you want to override the existing values.
         * </p>
         * 
         * @param invalidParameters
         *        A list of parameters that are not formatted correctly or do not run when executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidParameters(String... invalidParameters);
    }

    private static final class BuilderImpl implements Builder {
        private List<Parameter> parameters = new SdkInternalList<>();

        private List<String> invalidParameters = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(GetParametersResponse model) {
            setParameters(model.parameters);
            setInvalidParameters(model.invalidParameters);
        }

        public final Collection<Parameter> getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParameterListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter... parameters) {
            if (this.parameters == null) {
                this.parameters = new SdkInternalList<>(parameters.length);
            }
            for (Parameter e : parameters) {
                this.parameters.add(e);
            }
            return this;
        }

        public final void setParameters(Collection<Parameter> parameters) {
            this.parameters = ParameterListCopier.copy(parameters);
        }

        @SafeVarargs
        public final void setParameters(Parameter... parameters) {
            if (this.parameters == null) {
                this.parameters = new SdkInternalList<>(parameters.length);
            }
            for (Parameter e : parameters) {
                this.parameters.add(e);
            }
        }

        public final Collection<String> getInvalidParameters() {
            return invalidParameters;
        }

        @Override
        public final Builder invalidParameters(Collection<String> invalidParameters) {
            this.invalidParameters = ParameterNameListCopier.copy(invalidParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidParameters(String... invalidParameters) {
            if (this.invalidParameters == null) {
                this.invalidParameters = new SdkInternalList<>(invalidParameters.length);
            }
            for (String e : invalidParameters) {
                this.invalidParameters.add(e);
            }
            return this;
        }

        public final void setInvalidParameters(Collection<String> invalidParameters) {
            this.invalidParameters = ParameterNameListCopier.copy(invalidParameters);
        }

        @SafeVarargs
        public final void setInvalidParameters(String... invalidParameters) {
            if (this.invalidParameters == null) {
                this.invalidParameters = new SdkInternalList<>(invalidParameters.length);
            }
            for (String e : invalidParameters) {
                this.invalidParameters.add(e);
            }
        }

        @Override
        public GetParametersResponse build() {
            return new GetParametersResponse(this);
        }
    }
}
