/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetMaintenanceWindowExecutionResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetMaintenanceWindowExecutionResponse.Builder, GetMaintenanceWindowExecutionResponse> {
    private final String windowExecutionId;

    private final List<String> taskIds;

    private final String status;

    private final String statusDetails;

    private final Date startTime;

    private final Date endTime;

    private GetMaintenanceWindowExecutionResponse(BuilderImpl builder) {
        this.windowExecutionId = builder.windowExecutionId;
        this.taskIds = builder.taskIds;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    /**
     * <p>
     * The ID of the Maintenance Window execution.
     * </p>
     * 
     * @return The ID of the Maintenance Window execution.
     */
    public String windowExecutionId() {
        return windowExecutionId;
    }

    /**
     * <p>
     * The ID of the task executions from the Maintenance Window execution.
     * </p>
     * 
     * @return The ID of the task executions from the Maintenance Window execution.
     */
    public List<String> taskIds() {
        return taskIds;
    }

    /**
     * <p>
     * The status of the Maintenance Window execution.
     * </p>
     * 
     * @return The status of the Maintenance Window execution.
     * @see MaintenanceWindowExecutionStatus
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The details explaining the Status. Only available for certain status values.
     * </p>
     * 
     * @return The details explaining the Status. Only available for certain status values.
     */
    public String statusDetails() {
        return statusDetails;
    }

    /**
     * <p>
     * The time the Maintenance Window started executing.
     * </p>
     * 
     * @return The time the Maintenance Window started executing.
     */
    public Date startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time the Maintenance Window finished executing.
     * </p>
     * 
     * @return The time the Maintenance Window finished executing.
     */
    public Date endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((windowExecutionId() == null) ? 0 : windowExecutionId().hashCode());
        hashCode = 31 * hashCode + ((taskIds() == null) ? 0 : taskIds().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((statusDetails() == null) ? 0 : statusDetails().hashCode());
        hashCode = 31 * hashCode + ((startTime() == null) ? 0 : startTime().hashCode());
        hashCode = 31 * hashCode + ((endTime() == null) ? 0 : endTime().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMaintenanceWindowExecutionResponse)) {
            return false;
        }
        GetMaintenanceWindowExecutionResponse other = (GetMaintenanceWindowExecutionResponse) obj;
        if (other.windowExecutionId() == null ^ this.windowExecutionId() == null) {
            return false;
        }
        if (other.windowExecutionId() != null && !other.windowExecutionId().equals(this.windowExecutionId())) {
            return false;
        }
        if (other.taskIds() == null ^ this.taskIds() == null) {
            return false;
        }
        if (other.taskIds() != null && !other.taskIds().equals(this.taskIds())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.statusDetails() == null ^ this.statusDetails() == null) {
            return false;
        }
        if (other.statusDetails() != null && !other.statusDetails().equals(this.statusDetails())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (windowExecutionId() != null) {
            sb.append("WindowExecutionId: ").append(windowExecutionId()).append(",");
        }
        if (taskIds() != null) {
            sb.append("TaskIds: ").append(taskIds()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (statusDetails() != null) {
            sb.append("StatusDetails: ").append(statusDetails()).append(",");
        }
        if (startTime() != null) {
            sb.append("StartTime: ").append(startTime()).append(",");
        }
        if (endTime() != null) {
            sb.append("EndTime: ").append(endTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetMaintenanceWindowExecutionResponse> {
        /**
         * <p>
         * The ID of the Maintenance Window execution.
         * </p>
         * 
         * @param windowExecutionId
         *        The ID of the Maintenance Window execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowExecutionId(String windowExecutionId);

        /**
         * <p>
         * The ID of the task executions from the Maintenance Window execution.
         * </p>
         * 
         * @param taskIds
         *        The ID of the task executions from the Maintenance Window execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskIds(Collection<String> taskIds);

        /**
         * <p>
         * The ID of the task executions from the Maintenance Window execution.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setTaskIds(java.util.Collection)} or {@link #withTaskIds(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param taskIds
         *        The ID of the task executions from the Maintenance Window execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskIds(String... taskIds);

        /**
         * <p>
         * The status of the Maintenance Window execution.
         * </p>
         * 
         * @param status
         *        The status of the Maintenance Window execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceWindowExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the Maintenance Window execution.
         * </p>
         * 
         * @param status
         *        The status of the Maintenance Window execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceWindowExecutionStatus
         */
        Builder status(MaintenanceWindowExecutionStatus status);

        /**
         * <p>
         * The details explaining the Status. Only available for certain status values.
         * </p>
         * 
         * @param statusDetails
         *        The details explaining the Status. Only available for certain status values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDetails(String statusDetails);

        /**
         * <p>
         * The time the Maintenance Window started executing.
         * </p>
         * 
         * @param startTime
         *        The time the Maintenance Window started executing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Date startTime);

        /**
         * <p>
         * The time the Maintenance Window finished executing.
         * </p>
         * 
         * @param endTime
         *        The time the Maintenance Window finished executing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Date endTime);
    }

    private static final class BuilderImpl implements Builder {
        private String windowExecutionId;

        private List<String> taskIds = new SdkInternalList<>();

        private String status;

        private String statusDetails;

        private Date startTime;

        private Date endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMaintenanceWindowExecutionResponse model) {
            setWindowExecutionId(model.windowExecutionId);
            setTaskIds(model.taskIds);
            setStatus(model.status);
            setStatusDetails(model.statusDetails);
            setStartTime(model.startTime);
            setEndTime(model.endTime);
        }

        public final String getWindowExecutionId() {
            return windowExecutionId;
        }

        @Override
        public final Builder windowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
            return this;
        }

        public final void setWindowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
        }

        public final Collection<String> getTaskIds() {
            return taskIds;
        }

        @Override
        public final Builder taskIds(Collection<String> taskIds) {
            this.taskIds = MaintenanceWindowExecutionTaskIdListCopier.copy(taskIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskIds(String... taskIds) {
            if (this.taskIds == null) {
                this.taskIds = new SdkInternalList<>(taskIds.length);
            }
            for (String e : taskIds) {
                this.taskIds.add(e);
            }
            return this;
        }

        public final void setTaskIds(Collection<String> taskIds) {
            this.taskIds = MaintenanceWindowExecutionTaskIdListCopier.copy(taskIds);
        }

        @SafeVarargs
        public final void setTaskIds(String... taskIds) {
            if (this.taskIds == null) {
                this.taskIds = new SdkInternalList<>(taskIds.length);
            }
            for (String e : taskIds) {
                this.taskIds.add(e);
            }
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MaintenanceWindowExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(MaintenanceWindowExecutionStatus status) {
            this.status(status.toString());
        }

        public final String getStatusDetails() {
            return statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        public final Date getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Date startTime) {
            this.startTime = StandardMemberCopier.copy(startTime);
            return this;
        }

        public final void setStartTime(Date startTime) {
            this.startTime = StandardMemberCopier.copy(startTime);
        }

        public final Date getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Date endTime) {
            this.endTime = StandardMemberCopier.copy(endTime);
            return this;
        }

        public final void setEndTime(Date endTime) {
            this.endTime = StandardMemberCopier.copy(endTime);
        }

        @Override
        public GetMaintenanceWindowExecutionResponse build() {
            return new GetMaintenanceWindowExecutionResponse(this);
        }
    }
}
