/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetAutomationExecutionRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetAutomationExecutionRequest.Builder, GetAutomationExecutionRequest> {
    private final String automationExecutionId;

    private GetAutomationExecutionRequest(BuilderImpl builder) {
        this.automationExecutionId = builder.automationExecutionId;
    }

    /**
     * <p>
     * The unique identifier for an existing automation execution to examine. The execution ID is returned by
     * StartAutomationExecution when the execution of an Automation document is initiated.
     * </p>
     * 
     * @return The unique identifier for an existing automation execution to examine. The execution ID is returned by
     *         StartAutomationExecution when the execution of an Automation document is initiated.
     */
    public String automationExecutionId() {
        return automationExecutionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((automationExecutionId() == null) ? 0 : automationExecutionId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAutomationExecutionRequest)) {
            return false;
        }
        GetAutomationExecutionRequest other = (GetAutomationExecutionRequest) obj;
        if (other.automationExecutionId() == null ^ this.automationExecutionId() == null) {
            return false;
        }
        if (other.automationExecutionId() != null && !other.automationExecutionId().equals(this.automationExecutionId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (automationExecutionId() != null) {
            sb.append("AutomationExecutionId: ").append(automationExecutionId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetAutomationExecutionRequest> {
        /**
         * <p>
         * The unique identifier for an existing automation execution to examine. The execution ID is returned by
         * StartAutomationExecution when the execution of an Automation document is initiated.
         * </p>
         * 
         * @param automationExecutionId
         *        The unique identifier for an existing automation execution to examine. The execution ID is returned by
         *        StartAutomationExecution when the execution of an Automation document is initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automationExecutionId(String automationExecutionId);
    }

    private static final class BuilderImpl implements Builder {
        private String automationExecutionId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAutomationExecutionRequest model) {
            setAutomationExecutionId(model.automationExecutionId);
        }

        public final String getAutomationExecutionId() {
            return automationExecutionId;
        }

        @Override
        public final Builder automationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
            return this;
        }

        public final void setAutomationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
        }

        @Override
        public GetAutomationExecutionRequest build() {
            return new GetAutomationExecutionRequest(this);
        }
    }
}
