/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.EffectivePatchMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The EffectivePatch structure defines metadata about a patch along with the approval state of the patch in a
 * particular patch baseline. The approval state includes information about whether the patch is currently approved, due
 * to be approved by a rule, explicitly approved, or explicitly rejected and the date the patch was or will be approved.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class EffectivePatch implements StructuredPojo, ToCopyableBuilder<EffectivePatch.Builder, EffectivePatch> {
    private final Patch patch;

    private final PatchStatus patchStatus;

    private EffectivePatch(BuilderImpl builder) {
        this.patch = builder.patch;
        this.patchStatus = builder.patchStatus;
    }

    /**
     * <p>
     * Provides metadata for a patch, including information such as the KB ID, severity, classification and a URL for
     * where more information can be obtained about the patch.
     * </p>
     * 
     * @return Provides metadata for a patch, including information such as the KB ID, severity, classification and a
     *         URL for where more information can be obtained about the patch.
     */
    public Patch patch() {
        return patch;
    }

    /**
     * <p>
     * The status of the patch in a patch baseline. This includes information about whether the patch is currently
     * approved, due to be approved by a rule, explicitly approved, or explicitly rejected and the date the patch was or
     * will be approved.
     * </p>
     * 
     * @return The status of the patch in a patch baseline. This includes information about whether the patch is
     *         currently approved, due to be approved by a rule, explicitly approved, or explicitly rejected and the
     *         date the patch was or will be approved.
     */
    public PatchStatus patchStatus() {
        return patchStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((patch() == null) ? 0 : patch().hashCode());
        hashCode = 31 * hashCode + ((patchStatus() == null) ? 0 : patchStatus().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EffectivePatch)) {
            return false;
        }
        EffectivePatch other = (EffectivePatch) obj;
        if (other.patch() == null ^ this.patch() == null) {
            return false;
        }
        if (other.patch() != null && !other.patch().equals(this.patch())) {
            return false;
        }
        if (other.patchStatus() == null ^ this.patchStatus() == null) {
            return false;
        }
        if (other.patchStatus() != null && !other.patchStatus().equals(this.patchStatus())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (patch() != null) {
            sb.append("Patch: ").append(patch()).append(",");
        }
        if (patchStatus() != null) {
            sb.append("PatchStatus: ").append(patchStatus()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EffectivePatchMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, EffectivePatch> {
        /**
         * <p>
         * Provides metadata for a patch, including information such as the KB ID, severity, classification and a URL
         * for where more information can be obtained about the patch.
         * </p>
         * 
         * @param patch
         *        Provides metadata for a patch, including information such as the KB ID, severity, classification and a
         *        URL for where more information can be obtained about the patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patch(Patch patch);

        /**
         * <p>
         * The status of the patch in a patch baseline. This includes information about whether the patch is currently
         * approved, due to be approved by a rule, explicitly approved, or explicitly rejected and the date the patch
         * was or will be approved.
         * </p>
         * 
         * @param patchStatus
         *        The status of the patch in a patch baseline. This includes information about whether the patch is
         *        currently approved, due to be approved by a rule, explicitly approved, or explicitly rejected and the
         *        date the patch was or will be approved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchStatus(PatchStatus patchStatus);
    }

    private static final class BuilderImpl implements Builder {
        private Patch patch;

        private PatchStatus patchStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(EffectivePatch model) {
            setPatch(model.patch);
            setPatchStatus(model.patchStatus);
        }

        public final Patch getPatch() {
            return patch;
        }

        @Override
        public final Builder patch(Patch patch) {
            this.patch = patch;
            return this;
        }

        public final void setPatch(Patch patch) {
            this.patch = patch;
        }

        public final PatchStatus getPatchStatus() {
            return patchStatus;
        }

        @Override
        public final Builder patchStatus(PatchStatus patchStatus) {
            this.patchStatus = patchStatus;
            return this;
        }

        public final void setPatchStatus(PatchStatus patchStatus) {
            this.patchStatus = patchStatus;
        }

        @Override
        public EffectivePatch build() {
            return new EffectivePatch(this);
        }
    }
}
