/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeMaintenanceWindowExecutionTasksResponse extends AmazonWebServiceResult<ResponseMetadata>
        implements
        ToCopyableBuilder<DescribeMaintenanceWindowExecutionTasksResponse.Builder, DescribeMaintenanceWindowExecutionTasksResponse> {
    private final List<MaintenanceWindowExecutionTaskIdentity> windowExecutionTaskIdentities;

    private final String nextToken;

    private DescribeMaintenanceWindowExecutionTasksResponse(BuilderImpl builder) {
        this.windowExecutionTaskIdentities = builder.windowExecutionTaskIdentities;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the task executions.
     * </p>
     * 
     * @return Information about the task executions.
     */
    public List<MaintenanceWindowExecutionTaskIdentity> windowExecutionTaskIdentities() {
        return windowExecutionTaskIdentities;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((windowExecutionTaskIdentities() == null) ? 0 : windowExecutionTaskIdentities().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowExecutionTasksResponse)) {
            return false;
        }
        DescribeMaintenanceWindowExecutionTasksResponse other = (DescribeMaintenanceWindowExecutionTasksResponse) obj;
        if (other.windowExecutionTaskIdentities() == null ^ this.windowExecutionTaskIdentities() == null) {
            return false;
        }
        if (other.windowExecutionTaskIdentities() != null
                && !other.windowExecutionTaskIdentities().equals(this.windowExecutionTaskIdentities())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (windowExecutionTaskIdentities() != null) {
            sb.append("WindowExecutionTaskIdentities: ").append(windowExecutionTaskIdentities()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeMaintenanceWindowExecutionTasksResponse> {
        /**
         * <p>
         * Information about the task executions.
         * </p>
         * 
         * @param windowExecutionTaskIdentities
         *        Information about the task executions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowExecutionTaskIdentities(Collection<MaintenanceWindowExecutionTaskIdentity> windowExecutionTaskIdentities);

        /**
         * <p>
         * Information about the task executions.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setWindowExecutionTaskIdentities(java.util.Collection)} or
         * {@link #withWindowExecutionTaskIdentities(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param windowExecutionTaskIdentities
         *        Information about the task executions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowExecutionTaskIdentities(MaintenanceWindowExecutionTaskIdentity... windowExecutionTaskIdentities);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<MaintenanceWindowExecutionTaskIdentity> windowExecutionTaskIdentities = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowExecutionTasksResponse model) {
            setWindowExecutionTaskIdentities(model.windowExecutionTaskIdentities);
            setNextToken(model.nextToken);
        }

        public final Collection<MaintenanceWindowExecutionTaskIdentity> getWindowExecutionTaskIdentities() {
            return windowExecutionTaskIdentities;
        }

        @Override
        public final Builder windowExecutionTaskIdentities(
                Collection<MaintenanceWindowExecutionTaskIdentity> windowExecutionTaskIdentities) {
            this.windowExecutionTaskIdentities = MaintenanceWindowExecutionTaskIdentityListCopier
                    .copy(windowExecutionTaskIdentities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder windowExecutionTaskIdentities(
                MaintenanceWindowExecutionTaskIdentity... windowExecutionTaskIdentities) {
            if (this.windowExecutionTaskIdentities == null) {
                this.windowExecutionTaskIdentities = new SdkInternalList<>(windowExecutionTaskIdentities.length);
            }
            for (MaintenanceWindowExecutionTaskIdentity e : windowExecutionTaskIdentities) {
                this.windowExecutionTaskIdentities.add(e);
            }
            return this;
        }

        public final void setWindowExecutionTaskIdentities(
                Collection<MaintenanceWindowExecutionTaskIdentity> windowExecutionTaskIdentities) {
            this.windowExecutionTaskIdentities = MaintenanceWindowExecutionTaskIdentityListCopier
                    .copy(windowExecutionTaskIdentities);
        }

        @SafeVarargs
        public final void setWindowExecutionTaskIdentities(
                MaintenanceWindowExecutionTaskIdentity... windowExecutionTaskIdentities) {
            if (this.windowExecutionTaskIdentities == null) {
                this.windowExecutionTaskIdentities = new SdkInternalList<>(windowExecutionTaskIdentities.length);
            }
            for (MaintenanceWindowExecutionTaskIdentity e : windowExecutionTaskIdentities) {
                this.windowExecutionTaskIdentities.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeMaintenanceWindowExecutionTasksResponse build() {
            return new DescribeMaintenanceWindowExecutionTasksResponse(this);
        }
    }
}
