/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeMaintenanceWindowExecutionTaskInvocationsResponse extends AmazonWebServiceResult<ResponseMetadata>
        implements
        ToCopyableBuilder<DescribeMaintenanceWindowExecutionTaskInvocationsResponse.Builder, DescribeMaintenanceWindowExecutionTaskInvocationsResponse> {
    private final List<MaintenanceWindowExecutionTaskInvocationIdentity> windowExecutionTaskInvocationIdentities;

    private final String nextToken;

    private DescribeMaintenanceWindowExecutionTaskInvocationsResponse(BuilderImpl builder) {
        this.windowExecutionTaskInvocationIdentities = builder.windowExecutionTaskInvocationIdentities;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the task invocation results per invocation.
     * </p>
     * 
     * @return Information about the task invocation results per invocation.
     */
    public List<MaintenanceWindowExecutionTaskInvocationIdentity> windowExecutionTaskInvocationIdentities() {
        return windowExecutionTaskInvocationIdentities;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31
                * hashCode
                + ((windowExecutionTaskInvocationIdentities() == null) ? 0 : windowExecutionTaskInvocationIdentities().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowExecutionTaskInvocationsResponse)) {
            return false;
        }
        DescribeMaintenanceWindowExecutionTaskInvocationsResponse other = (DescribeMaintenanceWindowExecutionTaskInvocationsResponse) obj;
        if (other.windowExecutionTaskInvocationIdentities() == null ^ this.windowExecutionTaskInvocationIdentities() == null) {
            return false;
        }
        if (other.windowExecutionTaskInvocationIdentities() != null
                && !other.windowExecutionTaskInvocationIdentities().equals(this.windowExecutionTaskInvocationIdentities())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (windowExecutionTaskInvocationIdentities() != null) {
            sb.append("WindowExecutionTaskInvocationIdentities: ").append(windowExecutionTaskInvocationIdentities()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeMaintenanceWindowExecutionTaskInvocationsResponse> {
        /**
         * <p>
         * Information about the task invocation results per invocation.
         * </p>
         * 
         * @param windowExecutionTaskInvocationIdentities
         *        Information about the task invocation results per invocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowExecutionTaskInvocationIdentities(
                Collection<MaintenanceWindowExecutionTaskInvocationIdentity> windowExecutionTaskInvocationIdentities);

        /**
         * <p>
         * Information about the task invocation results per invocation.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setWindowExecutionTaskInvocationIdentities(java.util.Collection)} or
         * {@link #withWindowExecutionTaskInvocationIdentities(java.util.Collection)} if you want to override the
         * existing values.
         * </p>
         * 
         * @param windowExecutionTaskInvocationIdentities
         *        Information about the task invocation results per invocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowExecutionTaskInvocationIdentities(
                MaintenanceWindowExecutionTaskInvocationIdentity... windowExecutionTaskInvocationIdentities);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<MaintenanceWindowExecutionTaskInvocationIdentity> windowExecutionTaskInvocationIdentities = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowExecutionTaskInvocationsResponse model) {
            setWindowExecutionTaskInvocationIdentities(model.windowExecutionTaskInvocationIdentities);
            setNextToken(model.nextToken);
        }

        public final Collection<MaintenanceWindowExecutionTaskInvocationIdentity> getWindowExecutionTaskInvocationIdentities() {
            return windowExecutionTaskInvocationIdentities;
        }

        @Override
        public final Builder windowExecutionTaskInvocationIdentities(
                Collection<MaintenanceWindowExecutionTaskInvocationIdentity> windowExecutionTaskInvocationIdentities) {
            this.windowExecutionTaskInvocationIdentities = MaintenanceWindowExecutionTaskInvocationIdentityListCopier
                    .copy(windowExecutionTaskInvocationIdentities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder windowExecutionTaskInvocationIdentities(
                MaintenanceWindowExecutionTaskInvocationIdentity... windowExecutionTaskInvocationIdentities) {
            if (this.windowExecutionTaskInvocationIdentities == null) {
                this.windowExecutionTaskInvocationIdentities = new SdkInternalList<>(
                        windowExecutionTaskInvocationIdentities.length);
            }
            for (MaintenanceWindowExecutionTaskInvocationIdentity e : windowExecutionTaskInvocationIdentities) {
                this.windowExecutionTaskInvocationIdentities.add(e);
            }
            return this;
        }

        public final void setWindowExecutionTaskInvocationIdentities(
                Collection<MaintenanceWindowExecutionTaskInvocationIdentity> windowExecutionTaskInvocationIdentities) {
            this.windowExecutionTaskInvocationIdentities = MaintenanceWindowExecutionTaskInvocationIdentityListCopier
                    .copy(windowExecutionTaskInvocationIdentities);
        }

        @SafeVarargs
        public final void setWindowExecutionTaskInvocationIdentities(
                MaintenanceWindowExecutionTaskInvocationIdentity... windowExecutionTaskInvocationIdentities) {
            if (this.windowExecutionTaskInvocationIdentities == null) {
                this.windowExecutionTaskInvocationIdentities = new SdkInternalList<>(
                        windowExecutionTaskInvocationIdentities.length);
            }
            for (MaintenanceWindowExecutionTaskInvocationIdentity e : windowExecutionTaskInvocationIdentities) {
                this.windowExecutionTaskInvocationIdentities.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeMaintenanceWindowExecutionTaskInvocationsResponse build() {
            return new DescribeMaintenanceWindowExecutionTaskInvocationsResponse(this);
        }
    }
}
