/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeEffectivePatchesForPatchBaselineResponse extends AmazonWebServiceResult<ResponseMetadata>
        implements
        ToCopyableBuilder<DescribeEffectivePatchesForPatchBaselineResponse.Builder, DescribeEffectivePatchesForPatchBaselineResponse> {
    private final List<EffectivePatch> effectivePatches;

    private final String nextToken;

    private DescribeEffectivePatchesForPatchBaselineResponse(BuilderImpl builder) {
        this.effectivePatches = builder.effectivePatches;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An array of patches and patch status.
     * </p>
     * 
     * @return An array of patches and patch status.
     */
    public List<EffectivePatch> effectivePatches() {
        return effectivePatches;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((effectivePatches() == null) ? 0 : effectivePatches().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEffectivePatchesForPatchBaselineResponse)) {
            return false;
        }
        DescribeEffectivePatchesForPatchBaselineResponse other = (DescribeEffectivePatchesForPatchBaselineResponse) obj;
        if (other.effectivePatches() == null ^ this.effectivePatches() == null) {
            return false;
        }
        if (other.effectivePatches() != null && !other.effectivePatches().equals(this.effectivePatches())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (effectivePatches() != null) {
            sb.append("EffectivePatches: ").append(effectivePatches()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeEffectivePatchesForPatchBaselineResponse> {
        /**
         * <p>
         * An array of patches and patch status.
         * </p>
         * 
         * @param effectivePatches
         *        An array of patches and patch status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectivePatches(Collection<EffectivePatch> effectivePatches);

        /**
         * <p>
         * An array of patches and patch status.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setEffectivePatches(java.util.Collection)} or {@link #withEffectivePatches(java.util.Collection)} if
         * you want to override the existing values.
         * </p>
         * 
         * @param effectivePatches
         *        An array of patches and patch status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectivePatches(EffectivePatch... effectivePatches);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<EffectivePatch> effectivePatches = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEffectivePatchesForPatchBaselineResponse model) {
            setEffectivePatches(model.effectivePatches);
            setNextToken(model.nextToken);
        }

        public final Collection<EffectivePatch> getEffectivePatches() {
            return effectivePatches;
        }

        @Override
        public final Builder effectivePatches(Collection<EffectivePatch> effectivePatches) {
            this.effectivePatches = EffectivePatchListCopier.copy(effectivePatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder effectivePatches(EffectivePatch... effectivePatches) {
            if (this.effectivePatches == null) {
                this.effectivePatches = new SdkInternalList<>(effectivePatches.length);
            }
            for (EffectivePatch e : effectivePatches) {
                this.effectivePatches.add(e);
            }
            return this;
        }

        public final void setEffectivePatches(Collection<EffectivePatch> effectivePatches) {
            this.effectivePatches = EffectivePatchListCopier.copy(effectivePatches);
        }

        @SafeVarargs
        public final void setEffectivePatches(EffectivePatch... effectivePatches) {
            if (this.effectivePatches == null) {
                this.effectivePatches = new SdkInternalList<>(effectivePatches.length);
            }
            for (EffectivePatch e : effectivePatches) {
                this.effectivePatches.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeEffectivePatchesForPatchBaselineResponse build() {
            return new DescribeEffectivePatchesForPatchBaselineResponse(this);
        }
    }
}
