/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeActivationsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeActivationsResponse.Builder, DescribeActivationsResponse> {
    private final List<Activation> activationList;

    private final String nextToken;

    private DescribeActivationsResponse(BuilderImpl builder) {
        this.activationList = builder.activationList;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of activations for your AWS account.
     * </p>
     * 
     * @return A list of activations for your AWS account.
     */
    public List<Activation> activationList() {
        return activationList;
    }

    /**
     * <p>
     * The token for the next set of items to return. Use this token to get the next set of results.
     * </p>
     * 
     * @return The token for the next set of items to return. Use this token to get the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((activationList() == null) ? 0 : activationList().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeActivationsResponse)) {
            return false;
        }
        DescribeActivationsResponse other = (DescribeActivationsResponse) obj;
        if (other.activationList() == null ^ this.activationList() == null) {
            return false;
        }
        if (other.activationList() != null && !other.activationList().equals(this.activationList())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (activationList() != null) {
            sb.append("ActivationList: ").append(activationList()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeActivationsResponse> {
        /**
         * <p>
         * A list of activations for your AWS account.
         * </p>
         * 
         * @param activationList
         *        A list of activations for your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activationList(Collection<Activation> activationList);

        /**
         * <p>
         * A list of activations for your AWS account.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setActivationList(java.util.Collection)} or {@link #withActivationList(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param activationList
         *        A list of activations for your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activationList(Activation... activationList);

        /**
         * <p>
         * The token for the next set of items to return. Use this token to get the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. Use this token to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<Activation> activationList = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeActivationsResponse model) {
            setActivationList(model.activationList);
            setNextToken(model.nextToken);
        }

        public final Collection<Activation> getActivationList() {
            return activationList;
        }

        @Override
        public final Builder activationList(Collection<Activation> activationList) {
            this.activationList = ActivationListCopier.copy(activationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activationList(Activation... activationList) {
            if (this.activationList == null) {
                this.activationList = new SdkInternalList<>(activationList.length);
            }
            for (Activation e : activationList) {
                this.activationList.add(e);
            }
            return this;
        }

        public final void setActivationList(Collection<Activation> activationList) {
            this.activationList = ActivationListCopier.copy(activationList);
        }

        @SafeVarargs
        public final void setActivationList(Activation... activationList) {
            if (this.activationList == null) {
                this.activationList = new SdkInternalList<>(activationList.length);
            }
            for (Activation e : activationList) {
                this.activationList.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeActivationsResponse build() {
            return new DescribeActivationsResponse(this);
        }
    }
}
