/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateActivationResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateActivationResponse.Builder, CreateActivationResponse> {
    private final String activationId;

    private final String activationCode;

    private CreateActivationResponse(BuilderImpl builder) {
        this.activationId = builder.activationId;
        this.activationCode = builder.activationCode;
    }

    /**
     * <p>
     * The ID number generated by the system when it processed the activation. The activation ID functions like a user
     * name.
     * </p>
     * 
     * @return The ID number generated by the system when it processed the activation. The activation ID functions like
     *         a user name.
     */
    public String activationId() {
        return activationId;
    }

    /**
     * <p>
     * The code the system generates when it processes the activation. The activation code functions like a password to
     * validate the activation ID.
     * </p>
     * 
     * @return The code the system generates when it processes the activation. The activation code functions like a
     *         password to validate the activation ID.
     */
    public String activationCode() {
        return activationCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((activationId() == null) ? 0 : activationId().hashCode());
        hashCode = 31 * hashCode + ((activationCode() == null) ? 0 : activationCode().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateActivationResponse)) {
            return false;
        }
        CreateActivationResponse other = (CreateActivationResponse) obj;
        if (other.activationId() == null ^ this.activationId() == null) {
            return false;
        }
        if (other.activationId() != null && !other.activationId().equals(this.activationId())) {
            return false;
        }
        if (other.activationCode() == null ^ this.activationCode() == null) {
            return false;
        }
        if (other.activationCode() != null && !other.activationCode().equals(this.activationCode())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (activationId() != null) {
            sb.append("ActivationId: ").append(activationId()).append(",");
        }
        if (activationCode() != null) {
            sb.append("ActivationCode: ").append(activationCode()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateActivationResponse> {
        /**
         * <p>
         * The ID number generated by the system when it processed the activation. The activation ID functions like a
         * user name.
         * </p>
         * 
         * @param activationId
         *        The ID number generated by the system when it processed the activation. The activation ID functions
         *        like a user name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activationId(String activationId);

        /**
         * <p>
         * The code the system generates when it processes the activation. The activation code functions like a password
         * to validate the activation ID.
         * </p>
         * 
         * @param activationCode
         *        The code the system generates when it processes the activation. The activation code functions like a
         *        password to validate the activation ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activationCode(String activationCode);
    }

    private static final class BuilderImpl implements Builder {
        private String activationId;

        private String activationCode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateActivationResponse model) {
            setActivationId(model.activationId);
            setActivationCode(model.activationCode);
        }

        public final String getActivationId() {
            return activationId;
        }

        @Override
        public final Builder activationId(String activationId) {
            this.activationId = activationId;
            return this;
        }

        public final void setActivationId(String activationId) {
            this.activationId = activationId;
        }

        public final String getActivationCode() {
            return activationCode;
        }

        @Override
        public final Builder activationCode(String activationCode) {
            this.activationCode = activationCode;
            return this;
        }

        public final void setActivationCode(String activationCode) {
            this.activationCode = activationCode;
        }

        @Override
        public CreateActivationResponse build() {
            return new CreateActivationResponse(this);
        }
    }
}
