/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class CancelCommandRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CancelCommandRequest.Builder, CancelCommandRequest> {
    private final String commandId;

    private final List<String> instanceIds;

    private CancelCommandRequest(BuilderImpl builder) {
        this.commandId = builder.commandId;
        this.instanceIds = builder.instanceIds;
    }

    /**
     * <p>
     * The ID of the command you want to cancel.
     * </p>
     * 
     * @return The ID of the command you want to cancel.
     */
    public String commandId() {
        return commandId;
    }

    /**
     * <p>
     * (Optional) A list of instance IDs on which you want to cancel the command. If not provided, the command is
     * canceled on every instance on which it was requested.
     * </p>
     * 
     * @return (Optional) A list of instance IDs on which you want to cancel the command. If not provided, the command
     *         is canceled on every instance on which it was requested.
     */
    public List<String> instanceIds() {
        return instanceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((commandId() == null) ? 0 : commandId().hashCode());
        hashCode = 31 * hashCode + ((instanceIds() == null) ? 0 : instanceIds().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelCommandRequest)) {
            return false;
        }
        CancelCommandRequest other = (CancelCommandRequest) obj;
        if (other.commandId() == null ^ this.commandId() == null) {
            return false;
        }
        if (other.commandId() != null && !other.commandId().equals(this.commandId())) {
            return false;
        }
        if (other.instanceIds() == null ^ this.instanceIds() == null) {
            return false;
        }
        if (other.instanceIds() != null && !other.instanceIds().equals(this.instanceIds())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (commandId() != null) {
            sb.append("CommandId: ").append(commandId()).append(",");
        }
        if (instanceIds() != null) {
            sb.append("InstanceIds: ").append(instanceIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CancelCommandRequest> {
        /**
         * <p>
         * The ID of the command you want to cancel.
         * </p>
         * 
         * @param commandId
         *        The ID of the command you want to cancel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandId(String commandId);

        /**
         * <p>
         * (Optional) A list of instance IDs on which you want to cancel the command. If not provided, the command is
         * canceled on every instance on which it was requested.
         * </p>
         * 
         * @param instanceIds
         *        (Optional) A list of instance IDs on which you want to cancel the command. If not provided, the
         *        command is canceled on every instance on which it was requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(Collection<String> instanceIds);

        /**
         * <p>
         * (Optional) A list of instance IDs on which you want to cancel the command. If not provided, the command is
         * canceled on every instance on which it was requested.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setInstanceIds(java.util.Collection)} or {@link #withInstanceIds(java.util.Collection)} if you want
         * to override the existing values.
         * </p>
         * 
         * @param instanceIds
         *        (Optional) A list of instance IDs on which you want to cancel the command. If not provided, the
         *        command is canceled on every instance on which it was requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(String... instanceIds);
    }

    private static final class BuilderImpl implements Builder {
        private String commandId;

        private List<String> instanceIds = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(CancelCommandRequest model) {
            setCommandId(model.commandId);
            setInstanceIds(model.instanceIds);
        }

        public final String getCommandId() {
            return commandId;
        }

        @Override
        public final Builder commandId(String commandId) {
            this.commandId = commandId;
            return this;
        }

        public final void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        public final Collection<String> getInstanceIds() {
            return instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdListCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String... instanceIds) {
            if (this.instanceIds == null) {
                this.instanceIds = new SdkInternalList<>(instanceIds.length);
            }
            for (String e : instanceIds) {
                this.instanceIds.add(e);
            }
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdListCopier.copy(instanceIds);
        }

        @SafeVarargs
        public final void setInstanceIds(String... instanceIds) {
            if (this.instanceIds == null) {
                this.instanceIds = new SdkInternalList<>(instanceIds.length);
            }
            for (String e : instanceIds) {
                this.instanceIds.add(e);
            }
        }

        @Override
        public CancelCommandRequest build() {
            return new CancelCommandRequest(this);
        }
    }
}
