/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.ssm.transform.AutomationExecutionMetadataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a specific Automation execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AutomationExecutionMetadata implements StructuredPojo,
        ToCopyableBuilder<AutomationExecutionMetadata.Builder, AutomationExecutionMetadata> {
    private final String automationExecutionId;

    private final String documentName;

    private final String documentVersion;

    private final String automationExecutionStatus;

    private final Date executionStartTime;

    private final Date executionEndTime;

    private final String executedBy;

    private final String logFile;

    private final Map<String, List<String>> outputs;

    private AutomationExecutionMetadata(BuilderImpl builder) {
        this.automationExecutionId = builder.automationExecutionId;
        this.documentName = builder.documentName;
        this.documentVersion = builder.documentVersion;
        this.automationExecutionStatus = builder.automationExecutionStatus;
        this.executionStartTime = builder.executionStartTime;
        this.executionEndTime = builder.executionEndTime;
        this.executedBy = builder.executedBy;
        this.logFile = builder.logFile;
        this.outputs = builder.outputs;
    }

    /**
     * <p>
     * The execution ID.
     * </p>
     * 
     * @return The execution ID.
     */
    public String automationExecutionId() {
        return automationExecutionId;
    }

    /**
     * <p>
     * The name of the Automation document used during execution.
     * </p>
     * 
     * @return The name of the Automation document used during execution.
     */
    public String documentName() {
        return documentName;
    }

    /**
     * <p>
     * The document version used during the execution.
     * </p>
     * 
     * @return The document version used during the execution.
     */
    public String documentVersion() {
        return documentVersion;
    }

    /**
     * <p>
     * The status of the execution. Valid values include: Running, Succeeded, Failed, Timed out, or Cancelled.
     * </p>
     * 
     * @return The status of the execution. Valid values include: Running, Succeeded, Failed, Timed out, or Cancelled.
     * @see AutomationExecutionStatus
     */
    public String automationExecutionStatus() {
        return automationExecutionStatus;
    }

    /**
     * <p>
     * The time the execution started.&gt;
     * </p>
     * 
     * @return The time the execution started.&gt;
     */
    public Date executionStartTime() {
        return executionStartTime;
    }

    /**
     * <p>
     * The time the execution finished. This is not populated if the execution is still in progress.
     * </p>
     * 
     * @return The time the execution finished. This is not populated if the execution is still in progress.
     */
    public Date executionEndTime() {
        return executionEndTime;
    }

    /**
     * <p>
     * The IAM role ARN of the user who executed the Automation.
     * </p>
     * 
     * @return The IAM role ARN of the user who executed the Automation.
     */
    public String executedBy() {
        return executedBy;
    }

    /**
     * <p>
     * An Amazon S3 bucket where execution information is stored.
     * </p>
     * 
     * @return An Amazon S3 bucket where execution information is stored.
     */
    public String logFile() {
        return logFile;
    }

    /**
     * <p>
     * The list of execution outputs as defined in the Automation document.
     * </p>
     * 
     * @return The list of execution outputs as defined in the Automation document.
     */
    public Map<String, List<String>> outputs() {
        return outputs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((automationExecutionId() == null) ? 0 : automationExecutionId().hashCode());
        hashCode = 31 * hashCode + ((documentName() == null) ? 0 : documentName().hashCode());
        hashCode = 31 * hashCode + ((documentVersion() == null) ? 0 : documentVersion().hashCode());
        hashCode = 31 * hashCode + ((automationExecutionStatus() == null) ? 0 : automationExecutionStatus().hashCode());
        hashCode = 31 * hashCode + ((executionStartTime() == null) ? 0 : executionStartTime().hashCode());
        hashCode = 31 * hashCode + ((executionEndTime() == null) ? 0 : executionEndTime().hashCode());
        hashCode = 31 * hashCode + ((executedBy() == null) ? 0 : executedBy().hashCode());
        hashCode = 31 * hashCode + ((logFile() == null) ? 0 : logFile().hashCode());
        hashCode = 31 * hashCode + ((outputs() == null) ? 0 : outputs().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationExecutionMetadata)) {
            return false;
        }
        AutomationExecutionMetadata other = (AutomationExecutionMetadata) obj;
        if (other.automationExecutionId() == null ^ this.automationExecutionId() == null) {
            return false;
        }
        if (other.automationExecutionId() != null && !other.automationExecutionId().equals(this.automationExecutionId())) {
            return false;
        }
        if (other.documentName() == null ^ this.documentName() == null) {
            return false;
        }
        if (other.documentName() != null && !other.documentName().equals(this.documentName())) {
            return false;
        }
        if (other.documentVersion() == null ^ this.documentVersion() == null) {
            return false;
        }
        if (other.documentVersion() != null && !other.documentVersion().equals(this.documentVersion())) {
            return false;
        }
        if (other.automationExecutionStatus() == null ^ this.automationExecutionStatus() == null) {
            return false;
        }
        if (other.automationExecutionStatus() != null
                && !other.automationExecutionStatus().equals(this.automationExecutionStatus())) {
            return false;
        }
        if (other.executionStartTime() == null ^ this.executionStartTime() == null) {
            return false;
        }
        if (other.executionStartTime() != null && !other.executionStartTime().equals(this.executionStartTime())) {
            return false;
        }
        if (other.executionEndTime() == null ^ this.executionEndTime() == null) {
            return false;
        }
        if (other.executionEndTime() != null && !other.executionEndTime().equals(this.executionEndTime())) {
            return false;
        }
        if (other.executedBy() == null ^ this.executedBy() == null) {
            return false;
        }
        if (other.executedBy() != null && !other.executedBy().equals(this.executedBy())) {
            return false;
        }
        if (other.logFile() == null ^ this.logFile() == null) {
            return false;
        }
        if (other.logFile() != null && !other.logFile().equals(this.logFile())) {
            return false;
        }
        if (other.outputs() == null ^ this.outputs() == null) {
            return false;
        }
        if (other.outputs() != null && !other.outputs().equals(this.outputs())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (automationExecutionId() != null) {
            sb.append("AutomationExecutionId: ").append(automationExecutionId()).append(",");
        }
        if (documentName() != null) {
            sb.append("DocumentName: ").append(documentName()).append(",");
        }
        if (documentVersion() != null) {
            sb.append("DocumentVersion: ").append(documentVersion()).append(",");
        }
        if (automationExecutionStatus() != null) {
            sb.append("AutomationExecutionStatus: ").append(automationExecutionStatus()).append(",");
        }
        if (executionStartTime() != null) {
            sb.append("ExecutionStartTime: ").append(executionStartTime()).append(",");
        }
        if (executionEndTime() != null) {
            sb.append("ExecutionEndTime: ").append(executionEndTime()).append(",");
        }
        if (executedBy() != null) {
            sb.append("ExecutedBy: ").append(executedBy()).append(",");
        }
        if (logFile() != null) {
            sb.append("LogFile: ").append(logFile()).append(",");
        }
        if (outputs() != null) {
            sb.append("Outputs: ").append(outputs()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutomationExecutionMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, AutomationExecutionMetadata> {
        /**
         * <p>
         * The execution ID.
         * </p>
         * 
         * @param automationExecutionId
         *        The execution ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automationExecutionId(String automationExecutionId);

        /**
         * <p>
         * The name of the Automation document used during execution.
         * </p>
         * 
         * @param documentName
         *        The name of the Automation document used during execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentName(String documentName);

        /**
         * <p>
         * The document version used during the execution.
         * </p>
         * 
         * @param documentVersion
         *        The document version used during the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersion(String documentVersion);

        /**
         * <p>
         * The status of the execution. Valid values include: Running, Succeeded, Failed, Timed out, or Cancelled.
         * </p>
         * 
         * @param automationExecutionStatus
         *        The status of the execution. Valid values include: Running, Succeeded, Failed, Timed out, or
         *        Cancelled.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomationExecutionStatus
         */
        Builder automationExecutionStatus(String automationExecutionStatus);

        /**
         * <p>
         * The status of the execution. Valid values include: Running, Succeeded, Failed, Timed out, or Cancelled.
         * </p>
         * 
         * @param automationExecutionStatus
         *        The status of the execution. Valid values include: Running, Succeeded, Failed, Timed out, or
         *        Cancelled.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomationExecutionStatus
         */
        Builder automationExecutionStatus(AutomationExecutionStatus automationExecutionStatus);

        /**
         * <p>
         * The time the execution started.&gt;
         * </p>
         * 
         * @param executionStartTime
         *        The time the execution started.&gt;
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStartTime(Date executionStartTime);

        /**
         * <p>
         * The time the execution finished. This is not populated if the execution is still in progress.
         * </p>
         * 
         * @param executionEndTime
         *        The time the execution finished. This is not populated if the execution is still in progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionEndTime(Date executionEndTime);

        /**
         * <p>
         * The IAM role ARN of the user who executed the Automation.
         * </p>
         * 
         * @param executedBy
         *        The IAM role ARN of the user who executed the Automation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executedBy(String executedBy);

        /**
         * <p>
         * An Amazon S3 bucket where execution information is stored.
         * </p>
         * 
         * @param logFile
         *        An Amazon S3 bucket where execution information is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logFile(String logFile);

        /**
         * <p>
         * The list of execution outputs as defined in the Automation document.
         * </p>
         * 
         * @param outputs
         *        The list of execution outputs as defined in the Automation document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Map<String, ? extends Collection<String>> outputs);
    }

    private static final class BuilderImpl implements Builder {
        private String automationExecutionId;

        private String documentName;

        private String documentVersion;

        private String automationExecutionStatus;

        private Date executionStartTime;

        private Date executionEndTime;

        private String executedBy;

        private String logFile;

        private Map<String, List<String>> outputs;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationExecutionMetadata model) {
            setAutomationExecutionId(model.automationExecutionId);
            setDocumentName(model.documentName);
            setDocumentVersion(model.documentVersion);
            setAutomationExecutionStatus(model.automationExecutionStatus);
            setExecutionStartTime(model.executionStartTime);
            setExecutionEndTime(model.executionEndTime);
            setExecutedBy(model.executedBy);
            setLogFile(model.logFile);
            setOutputs(model.outputs);
        }

        public final String getAutomationExecutionId() {
            return automationExecutionId;
        }

        @Override
        public final Builder automationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
            return this;
        }

        public final void setAutomationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
        }

        public final String getDocumentName() {
            return documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        public final String getDocumentVersion() {
            return documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final String getAutomationExecutionStatus() {
            return automationExecutionStatus;
        }

        @Override
        public final Builder automationExecutionStatus(String automationExecutionStatus) {
            this.automationExecutionStatus = automationExecutionStatus;
            return this;
        }

        @Override
        public final Builder automationExecutionStatus(AutomationExecutionStatus automationExecutionStatus) {
            this.automationExecutionStatus(automationExecutionStatus.toString());
            return this;
        }

        public final void setAutomationExecutionStatus(String automationExecutionStatus) {
            this.automationExecutionStatus = automationExecutionStatus;
        }

        public final void setAutomationExecutionStatus(AutomationExecutionStatus automationExecutionStatus) {
            this.automationExecutionStatus(automationExecutionStatus.toString());
        }

        public final Date getExecutionStartTime() {
            return executionStartTime;
        }

        @Override
        public final Builder executionStartTime(Date executionStartTime) {
            this.executionStartTime = StandardMemberCopier.copy(executionStartTime);
            return this;
        }

        public final void setExecutionStartTime(Date executionStartTime) {
            this.executionStartTime = StandardMemberCopier.copy(executionStartTime);
        }

        public final Date getExecutionEndTime() {
            return executionEndTime;
        }

        @Override
        public final Builder executionEndTime(Date executionEndTime) {
            this.executionEndTime = StandardMemberCopier.copy(executionEndTime);
            return this;
        }

        public final void setExecutionEndTime(Date executionEndTime) {
            this.executionEndTime = StandardMemberCopier.copy(executionEndTime);
        }

        public final String getExecutedBy() {
            return executedBy;
        }

        @Override
        public final Builder executedBy(String executedBy) {
            this.executedBy = executedBy;
            return this;
        }

        public final void setExecutedBy(String executedBy) {
            this.executedBy = executedBy;
        }

        public final String getLogFile() {
            return logFile;
        }

        @Override
        public final Builder logFile(String logFile) {
            this.logFile = logFile;
            return this;
        }

        public final void setLogFile(String logFile) {
            this.logFile = logFile;
        }

        public final Map<String, ? extends Collection<String>> getOutputs() {
            return outputs;
        }

        @Override
        public final Builder outputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
            return this;
        }

        public final void setOutputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
        }

        @Override
        public AutomationExecutionMetadata build() {
            return new AutomationExecutionMetadata(this);
        }
    }
}
