/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.ssm.transform.AutomationExecutionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about the current state of an individual Automation execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AutomationExecution implements StructuredPojo, ToCopyableBuilder<AutomationExecution.Builder, AutomationExecution> {
    private final String automationExecutionId;

    private final String documentName;

    private final String documentVersion;

    private final Date executionStartTime;

    private final Date executionEndTime;

    private final String automationExecutionStatus;

    private final List<StepExecution> stepExecutions;

    private final Map<String, List<String>> parameters;

    private final Map<String, List<String>> outputs;

    private final String failureMessage;

    private AutomationExecution(BuilderImpl builder) {
        this.automationExecutionId = builder.automationExecutionId;
        this.documentName = builder.documentName;
        this.documentVersion = builder.documentVersion;
        this.executionStartTime = builder.executionStartTime;
        this.executionEndTime = builder.executionEndTime;
        this.automationExecutionStatus = builder.automationExecutionStatus;
        this.stepExecutions = builder.stepExecutions;
        this.parameters = builder.parameters;
        this.outputs = builder.outputs;
        this.failureMessage = builder.failureMessage;
    }

    /**
     * <p>
     * The execution ID.
     * </p>
     * 
     * @return The execution ID.
     */
    public String automationExecutionId() {
        return automationExecutionId;
    }

    /**
     * <p>
     * The name of the Automation document used during the execution.
     * </p>
     * 
     * @return The name of the Automation document used during the execution.
     */
    public String documentName() {
        return documentName;
    }

    /**
     * <p>
     * The version of the document to use during execution.
     * </p>
     * 
     * @return The version of the document to use during execution.
     */
    public String documentVersion() {
        return documentVersion;
    }

    /**
     * <p>
     * The time the execution started.
     * </p>
     * 
     * @return The time the execution started.
     */
    public Date executionStartTime() {
        return executionStartTime;
    }

    /**
     * <p>
     * The time the execution finished.
     * </p>
     * 
     * @return The time the execution finished.
     */
    public Date executionEndTime() {
        return executionEndTime;
    }

    /**
     * <p>
     * The execution status of the Automation.
     * </p>
     * 
     * @return The execution status of the Automation.
     * @see AutomationExecutionStatus
     */
    public String automationExecutionStatus() {
        return automationExecutionStatus;
    }

    /**
     * <p>
     * A list of details about the current state of all steps that comprise an execution. An Automation document
     * contains a list of steps that are executed in order.
     * </p>
     * 
     * @return A list of details about the current state of all steps that comprise an execution. An Automation document
     *         contains a list of steps that are executed in order.
     */
    public List<StepExecution> stepExecutions() {
        return stepExecutions;
    }

    /**
     * <p>
     * The key-value map of execution parameters, which were supplied when calling StartAutomationExecution.
     * </p>
     * 
     * @return The key-value map of execution parameters, which were supplied when calling StartAutomationExecution.
     */
    public Map<String, List<String>> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The list of execution outputs as defined in the automation document.
     * </p>
     * 
     * @return The list of execution outputs as defined in the automation document.
     */
    public Map<String, List<String>> outputs() {
        return outputs;
    }

    /**
     * <p>
     * A message describing why an execution has failed, if the status is set to Failed.
     * </p>
     * 
     * @return A message describing why an execution has failed, if the status is set to Failed.
     */
    public String failureMessage() {
        return failureMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((automationExecutionId() == null) ? 0 : automationExecutionId().hashCode());
        hashCode = 31 * hashCode + ((documentName() == null) ? 0 : documentName().hashCode());
        hashCode = 31 * hashCode + ((documentVersion() == null) ? 0 : documentVersion().hashCode());
        hashCode = 31 * hashCode + ((executionStartTime() == null) ? 0 : executionStartTime().hashCode());
        hashCode = 31 * hashCode + ((executionEndTime() == null) ? 0 : executionEndTime().hashCode());
        hashCode = 31 * hashCode + ((automationExecutionStatus() == null) ? 0 : automationExecutionStatus().hashCode());
        hashCode = 31 * hashCode + ((stepExecutions() == null) ? 0 : stepExecutions().hashCode());
        hashCode = 31 * hashCode + ((parameters() == null) ? 0 : parameters().hashCode());
        hashCode = 31 * hashCode + ((outputs() == null) ? 0 : outputs().hashCode());
        hashCode = 31 * hashCode + ((failureMessage() == null) ? 0 : failureMessage().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationExecution)) {
            return false;
        }
        AutomationExecution other = (AutomationExecution) obj;
        if (other.automationExecutionId() == null ^ this.automationExecutionId() == null) {
            return false;
        }
        if (other.automationExecutionId() != null && !other.automationExecutionId().equals(this.automationExecutionId())) {
            return false;
        }
        if (other.documentName() == null ^ this.documentName() == null) {
            return false;
        }
        if (other.documentName() != null && !other.documentName().equals(this.documentName())) {
            return false;
        }
        if (other.documentVersion() == null ^ this.documentVersion() == null) {
            return false;
        }
        if (other.documentVersion() != null && !other.documentVersion().equals(this.documentVersion())) {
            return false;
        }
        if (other.executionStartTime() == null ^ this.executionStartTime() == null) {
            return false;
        }
        if (other.executionStartTime() != null && !other.executionStartTime().equals(this.executionStartTime())) {
            return false;
        }
        if (other.executionEndTime() == null ^ this.executionEndTime() == null) {
            return false;
        }
        if (other.executionEndTime() != null && !other.executionEndTime().equals(this.executionEndTime())) {
            return false;
        }
        if (other.automationExecutionStatus() == null ^ this.automationExecutionStatus() == null) {
            return false;
        }
        if (other.automationExecutionStatus() != null
                && !other.automationExecutionStatus().equals(this.automationExecutionStatus())) {
            return false;
        }
        if (other.stepExecutions() == null ^ this.stepExecutions() == null) {
            return false;
        }
        if (other.stepExecutions() != null && !other.stepExecutions().equals(this.stepExecutions())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.outputs() == null ^ this.outputs() == null) {
            return false;
        }
        if (other.outputs() != null && !other.outputs().equals(this.outputs())) {
            return false;
        }
        if (other.failureMessage() == null ^ this.failureMessage() == null) {
            return false;
        }
        if (other.failureMessage() != null && !other.failureMessage().equals(this.failureMessage())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (automationExecutionId() != null) {
            sb.append("AutomationExecutionId: ").append(automationExecutionId()).append(",");
        }
        if (documentName() != null) {
            sb.append("DocumentName: ").append(documentName()).append(",");
        }
        if (documentVersion() != null) {
            sb.append("DocumentVersion: ").append(documentVersion()).append(",");
        }
        if (executionStartTime() != null) {
            sb.append("ExecutionStartTime: ").append(executionStartTime()).append(",");
        }
        if (executionEndTime() != null) {
            sb.append("ExecutionEndTime: ").append(executionEndTime()).append(",");
        }
        if (automationExecutionStatus() != null) {
            sb.append("AutomationExecutionStatus: ").append(automationExecutionStatus()).append(",");
        }
        if (stepExecutions() != null) {
            sb.append("StepExecutions: ").append(stepExecutions()).append(",");
        }
        if (parameters() != null) {
            sb.append("Parameters: ").append(parameters()).append(",");
        }
        if (outputs() != null) {
            sb.append("Outputs: ").append(outputs()).append(",");
        }
        if (failureMessage() != null) {
            sb.append("FailureMessage: ").append(failureMessage()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutomationExecutionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, AutomationExecution> {
        /**
         * <p>
         * The execution ID.
         * </p>
         * 
         * @param automationExecutionId
         *        The execution ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automationExecutionId(String automationExecutionId);

        /**
         * <p>
         * The name of the Automation document used during the execution.
         * </p>
         * 
         * @param documentName
         *        The name of the Automation document used during the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentName(String documentName);

        /**
         * <p>
         * The version of the document to use during execution.
         * </p>
         * 
         * @param documentVersion
         *        The version of the document to use during execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersion(String documentVersion);

        /**
         * <p>
         * The time the execution started.
         * </p>
         * 
         * @param executionStartTime
         *        The time the execution started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStartTime(Date executionStartTime);

        /**
         * <p>
         * The time the execution finished.
         * </p>
         * 
         * @param executionEndTime
         *        The time the execution finished.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionEndTime(Date executionEndTime);

        /**
         * <p>
         * The execution status of the Automation.
         * </p>
         * 
         * @param automationExecutionStatus
         *        The execution status of the Automation.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomationExecutionStatus
         */
        Builder automationExecutionStatus(String automationExecutionStatus);

        /**
         * <p>
         * The execution status of the Automation.
         * </p>
         * 
         * @param automationExecutionStatus
         *        The execution status of the Automation.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomationExecutionStatus
         */
        Builder automationExecutionStatus(AutomationExecutionStatus automationExecutionStatus);

        /**
         * <p>
         * A list of details about the current state of all steps that comprise an execution. An Automation document
         * contains a list of steps that are executed in order.
         * </p>
         * 
         * @param stepExecutions
         *        A list of details about the current state of all steps that comprise an execution. An Automation
         *        document contains a list of steps that are executed in order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepExecutions(Collection<StepExecution> stepExecutions);

        /**
         * <p>
         * A list of details about the current state of all steps that comprise an execution. An Automation document
         * contains a list of steps that are executed in order.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setStepExecutions(java.util.Collection)} or {@link #withStepExecutions(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param stepExecutions
         *        A list of details about the current state of all steps that comprise an execution. An Automation
         *        document contains a list of steps that are executed in order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepExecutions(StepExecution... stepExecutions);

        /**
         * <p>
         * The key-value map of execution parameters, which were supplied when calling StartAutomationExecution.
         * </p>
         * 
         * @param parameters
         *        The key-value map of execution parameters, which were supplied when calling StartAutomationExecution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, ? extends Collection<String>> parameters);

        /**
         * <p>
         * The list of execution outputs as defined in the automation document.
         * </p>
         * 
         * @param outputs
         *        The list of execution outputs as defined in the automation document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Map<String, ? extends Collection<String>> outputs);

        /**
         * <p>
         * A message describing why an execution has failed, if the status is set to Failed.
         * </p>
         * 
         * @param failureMessage
         *        A message describing why an execution has failed, if the status is set to Failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);
    }

    private static final class BuilderImpl implements Builder {
        private String automationExecutionId;

        private String documentName;

        private String documentVersion;

        private Date executionStartTime;

        private Date executionEndTime;

        private String automationExecutionStatus;

        private List<StepExecution> stepExecutions = new SdkInternalList<>();

        private Map<String, List<String>> parameters;

        private Map<String, List<String>> outputs;

        private String failureMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationExecution model) {
            setAutomationExecutionId(model.automationExecutionId);
            setDocumentName(model.documentName);
            setDocumentVersion(model.documentVersion);
            setExecutionStartTime(model.executionStartTime);
            setExecutionEndTime(model.executionEndTime);
            setAutomationExecutionStatus(model.automationExecutionStatus);
            setStepExecutions(model.stepExecutions);
            setParameters(model.parameters);
            setOutputs(model.outputs);
            setFailureMessage(model.failureMessage);
        }

        public final String getAutomationExecutionId() {
            return automationExecutionId;
        }

        @Override
        public final Builder automationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
            return this;
        }

        public final void setAutomationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
        }

        public final String getDocumentName() {
            return documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        public final String getDocumentVersion() {
            return documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final Date getExecutionStartTime() {
            return executionStartTime;
        }

        @Override
        public final Builder executionStartTime(Date executionStartTime) {
            this.executionStartTime = StandardMemberCopier.copy(executionStartTime);
            return this;
        }

        public final void setExecutionStartTime(Date executionStartTime) {
            this.executionStartTime = StandardMemberCopier.copy(executionStartTime);
        }

        public final Date getExecutionEndTime() {
            return executionEndTime;
        }

        @Override
        public final Builder executionEndTime(Date executionEndTime) {
            this.executionEndTime = StandardMemberCopier.copy(executionEndTime);
            return this;
        }

        public final void setExecutionEndTime(Date executionEndTime) {
            this.executionEndTime = StandardMemberCopier.copy(executionEndTime);
        }

        public final String getAutomationExecutionStatus() {
            return automationExecutionStatus;
        }

        @Override
        public final Builder automationExecutionStatus(String automationExecutionStatus) {
            this.automationExecutionStatus = automationExecutionStatus;
            return this;
        }

        @Override
        public final Builder automationExecutionStatus(AutomationExecutionStatus automationExecutionStatus) {
            this.automationExecutionStatus(automationExecutionStatus.toString());
            return this;
        }

        public final void setAutomationExecutionStatus(String automationExecutionStatus) {
            this.automationExecutionStatus = automationExecutionStatus;
        }

        public final void setAutomationExecutionStatus(AutomationExecutionStatus automationExecutionStatus) {
            this.automationExecutionStatus(automationExecutionStatus.toString());
        }

        public final Collection<StepExecution> getStepExecutions() {
            return stepExecutions;
        }

        @Override
        public final Builder stepExecutions(Collection<StepExecution> stepExecutions) {
            this.stepExecutions = StepExecutionListCopier.copy(stepExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepExecutions(StepExecution... stepExecutions) {
            if (this.stepExecutions == null) {
                this.stepExecutions = new SdkInternalList<>(stepExecutions.length);
            }
            for (StepExecution e : stepExecutions) {
                this.stepExecutions.add(e);
            }
            return this;
        }

        public final void setStepExecutions(Collection<StepExecution> stepExecutions) {
            this.stepExecutions = StepExecutionListCopier.copy(stepExecutions);
        }

        @SafeVarargs
        public final void setStepExecutions(StepExecution... stepExecutions) {
            if (this.stepExecutions == null) {
                this.stepExecutions = new SdkInternalList<>(stepExecutions.length);
            }
            for (StepExecution e : stepExecutions) {
                this.stepExecutions.add(e);
            }
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = AutomationParameterMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = AutomationParameterMapCopier.copy(parameters);
        }

        public final Map<String, ? extends Collection<String>> getOutputs() {
            return outputs;
        }

        @Override
        public final Builder outputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
            return this;
        }

        public final void setOutputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public AutomationExecution build() {
            return new AutomationExecution(this);
        }
    }
}
