/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.sns.model.UnsubscribeRequest;

public class UnsubscribeRequestMarshaller
implements Marshaller<Request<UnsubscribeRequest>, UnsubscribeRequest> {
    public Request<UnsubscribeRequest> marshall(UnsubscribeRequest unsubscribeRequest) {
        if (unsubscribeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)unsubscribeRequest, "SNSClient");
        request.addParameter("Action", "Unsubscribe");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (unsubscribeRequest.subscriptionArn() != null) {
            request.addParameter("SubscriptionArn", StringUtils.fromString((String)unsubscribeRequest.subscriptionArn()));
        }
        return request;
    }
}

